/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import org.openl.rules.table.ui.filters.GreyColorFilter;
import org.openl.rules.table.ui.filters.IColorFilter;
import org.openl.rules.table.ui.filters.TransparentColorFilter;

public class ColorFilterHolder {
    public static String[] filterNames = new String[]{"Red Filter", "Green Filter", "Blue Filter", "Grey Filter"};
    public static String[] imageNames = new String[]{"blend_red.png", "blend_green.png", "blend_blue.png", "blend_grey.png"};
    int transparency = 80;
    int filterType = 3;

    public String getFilterName() {
        return filterNames[this.filterType];
    }

    public int getFilterType() {
        return this.filterType;
    }

    public String getImageName() {
        return imageNames[this.filterType];
    }

    public int getTransparency() {
        return this.transparency;
    }

    public IColorFilter makeFilter() {
        double trcy = (double)this.transparency * 0.01;
        switch (this.filterType) {
            case 0: {
                return new TransparentColorFilter(IColorFilter.RED, trcy);
            }
            case 1: {
                return new TransparentColorFilter(IColorFilter.GREEN, trcy);
            }
            case 2: {
                return new TransparentColorFilter(IColorFilter.BLUE, trcy);
            }
            case 3: {
                return new GreyColorFilter(trcy);
            }
        }
        throw new RuntimeException("Unknown Filter Type: " + this.filterType);
    }

    public void setFilterType(int filterType) {
        this.filterType = filterType;
    }

    public void setTransparency(int transparency) {
        this.transparency = Math.max(0, Math.min(100, transparency));
    }
}

