/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import javax.faces.component.html.HtmlOutputText;
import org.openl.rules.tableeditor.renderkit.HTMLRenderer;
import org.openl.rules.tableeditor.renderkit.TableProperty;
import org.openl.util.EnumUtils;

public class EnumValuesUIHelper {
    private HtmlOutputText enumOutput;
    private HtmlOutputText enumArrayOutput;

    public void setEnumOutput(HtmlOutputText enumOutput) {
        this.enumOutput = enumOutput;
    }

    public HtmlOutputText getEnumOutput() {
        return this.enumOutput;
    }

    public void setEnumArrayOutput(HtmlOutputText enumArrayOutput) {
        this.enumArrayOutput = enumArrayOutput;
    }

    public HtmlOutputText getEnumArrayOutput() {
        return this.enumArrayOutput;
    }

    public String getEnumValue() {
        String componentId = this.enumOutput.getId();
        TableProperty property = (TableProperty)this.enumOutput.getAttributes().get("property");
        return this.getEnumSelectComponentCode(componentId, property);
    }

    public String getEnumArrayValue() {
        String componentId = this.enumArrayOutput.getId();
        TableProperty property = (TableProperty)this.enumArrayOutput.getAttributes().get("property");
        return this.getEnumMultiSelectComponentCode(componentId, property);
    }

    private String getEnumSelectComponentCode(String componentId, TableProperty tableProperty) {
        Class instanceClass = tableProperty.getType();
        String value = tableProperty.getStringValue();
        String[] values = EnumUtils.getNames((Class)instanceClass);
        String[] displayValues = EnumUtils.getValues((Class)instanceClass);
        String id = String.format("%s:%s:enumSelect", componentId, tableProperty.getName());
        String componentCode = new HTMLRenderer().getSingleSelectComponentCode(id, values, displayValues, value);
        return this.getEditorHTMLCode(id, componentCode);
    }

    private String getEnumMultiSelectComponentCode(String componentId, TableProperty tableProperty) {
        Class<?> instanceClass = tableProperty.getType().getComponentType();
        String valueString = tableProperty.getStringValue();
        String[] values = EnumUtils.getNames(instanceClass);
        String[] displayValues = EnumUtils.getValues(instanceClass);
        String id = String.format("%s:%s:enumArraySelect", componentId, tableProperty.getName());
        String componentCode = new HTMLRenderer().getMultiSelectComponentCode(id, values, displayValues, valueString);
        return this.getEditorHTMLCode(id, componentCode);
    }

    private String getEditorHTMLCode(String id, String editorCode) {
        return String.format("<div id='%1$s'></div><script type='text/javascript'>var editor = %2$s;editor.input.onblur=function(){var newValue = this.getValue();$('%1$s').next('input[type=hidden][name!=id]').value=newValue;return false;};</script>", id, editorCode);
    }
}

