/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openl.meta.DoubleValue;
import org.openl.meta.DoubleValueFormula;
import org.openl.meta.DoubleValueFunction;
import org.openl.meta.IMetaInfo;
import org.openl.rules.table.xls.XlsUrlParser;
import org.openl.rules.tableeditor.model.ui.util.HTMLHelper;
import org.openl.rules.ui.Explanator;
import org.openl.util.AOpenIterator;
import org.openl.util.OpenIterator;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringTool;
import org.openl.util.tree.TreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Explanation {
    static final int MAX_LEVEL = 2;
    DoubleValue root;
    List<DoubleValue> expandedValues = new ArrayList<DoubleValue>();
    String header;
    boolean showNamesInFormula = false;
    boolean showValuesInFormula = true;
    Explanator explanator;

    static String getName(DoubleValue value) {
        IMetaInfo mi = value.getMetaInfo();
        String name = mi != null ? mi.getDisplayName(2) : null;
        return name;
    }

    public Explanation(Explanator explanator) {
        this.explanator = explanator;
    }

    public void expand(String expandID) {
        DoubleValue dv = this.explanator.find(expandID);
        if (!this.expandedValues.contains(dv)) {
            this.expandedValues.add(dv);
        }
    }

    protected String expandArgument(DoubleValue value, boolean isMultiplicative, String parentUrl, int level) {
        DoubleValueFormula formula;
        String url = this.findUrl(value, parentUrl);
        if (value.getClass() == DoubleValueFormula.class && (formula = (DoubleValueFormula)value).isMultiplicative() == isMultiplicative && level < 2) {
            return this.expandFormula(formula, url, level + 1);
        }
        return this.expandValue(value);
    }

    protected String expandFormula(DoubleValueFormula formula, String parentUrl, int level) {
        String url = this.findUrl((DoubleValue)formula, parentUrl);
        return this.expandArgument(formula.getDv1(), formula.isMultiplicative(), url, level) + formula.getOperand() + this.expandArgument(formula.getDv2(), formula.isMultiplicative(), url, level);
    }

    private String expandFunction(DoubleValueFunction function, String parentUrl) {
        String url = this.findUrl((DoubleValue)function, parentUrl);
        String ret = function.getFunctionName() + "(";
        DoubleValue[] params = function.getParams();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                ret = ret + ", ";
            }
            ret = ret + this.expandArgument(params[i], false, url, 0);
        }
        return ret + ")";
    }

    public String expandValue(DoubleValue value) {
        String text = String.valueOf(value.getValue());
        String name = Explanation.getName(value);
        if (name != null && this.showNamesInFormula) {
            text = this.showValuesInFormula ? name + "(" + text + ")" : name;
        }
        if (this.expandedValues.contains(value)) {
            return text;
        }
        int id = this.explanator.getUniqueId(value);
        return HTMLHelper.urlLink((String)this.makeExpandUrl(id), (String)(name == null ? "expand" : name), (String)text, null);
    }

    public String findUrl(DoubleValue value, String parentUrl) {
        String url;
        IMetaInfo mi = value.getMetaInfo();
        String string = url = mi != null ? mi.getSourceUrl() : null;
        if (url == null) {
            return parentUrl;
        }
        return url;
    }

    public List<DoubleValue> getExpandedValues() {
        return this.expandedValues;
    }

    public String getHeader() {
        return this.header;
    }

    public DoubleValue getExplainTree() {
        return this.root;
    }

    public String htmlString(DoubleValue value) {
        if (value.getClass() == DoubleValueFormula.class) {
            return this.expandFormula((DoubleValueFormula)value, null, 0);
        }
        if (value.getClass() == DoubleValueFunction.class) {
            return this.expandFunction((DoubleValueFunction)value, null);
        }
        return this.expandValue(value);
    }

    public String[] htmlTable(DoubleValue value) {
        String name;
        String text = String.valueOf(value.getValue());
        String url = this.findUrl(value, null);
        IMetaInfo mi = value.getMetaInfo();
        String string = name = mi != null ? mi.getDisplayName(2) : null;
        if (url != null) {
            text = HTMLHelper.urlLink((String)this.makeUrl(url), (String)"show", (String)text, null);
        }
        if (name == null) {
            name = "";
        } else if (url != null) {
            name = HTMLHelper.urlLink((String)("showExplainTable.jsp?uri=" + StringTool.encodeURL((String)url) + "&text=" + name), (String)"show", (String)name, (String)"mainFrame");
        }
        return new String[]{text, name, this.htmlString(value)};
    }

    protected boolean isExpandable(DoubleValue value) {
        return value.getClass() == DoubleValueFormula.class || value.getClass() == DoubleValueFunction.class;
    }

    public boolean isShowNamesInFormula() {
        return this.showNamesInFormula;
    }

    public boolean isShowValuesInFormula() {
        return this.showValuesInFormula;
    }

    protected String makeBasicUrl() {
        return "?rootID=" + this.explanator.getUniqueId(this.root) + "&header=" + this.header + (this.showNamesInFormula ? "&showNames=true" : "") + (this.showValuesInFormula ? "&showValues=true" : "");
    }

    protected String makeExpandUrl(int id) {
        return this.makeBasicUrl() + "&expandID=" + id;
    }

    protected String makeUrl(String url) {
        if (url == null) {
            return "#";
        }
        XlsUrlParser parser = new XlsUrlParser();
        try {
            parser.parse(url);
        }
        catch (Exception e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
        String ret = this.makeBasicUrl() + "&wbPath=" + parser.wbPath + "&wbName=" + parser.wbName + "&wsName=" + parser.wsName + "&range=" + parser.range;
        return ret;
    }

    public void setExpandedValues(List<DoubleValue> expandedValues) {
        this.expandedValues = expandedValues;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setShowNamesInFormula(boolean showNamesInFormula) {
        this.showNamesInFormula = showNamesInFormula;
    }

    public void setShowValuesInFormula(boolean showValuesInFormula) {
        this.showValuesInFormula = showValuesInFormula;
    }

    static class DoubleValueIterator
    implements TreeIterator.TreeAdaptor {
        DoubleValueIterator() {
        }

        public Iterator children(Object node) {
            if (node.getClass() == DoubleValueFormula.class) {
                return OpenIterator.fromArray((Object[])((DoubleValueFormula)node).getArguments());
            }
            if (node.getClass() == DoubleValueFunction.class) {
                return OpenIterator.fromArray((Object[])((DoubleValueFunction)node).getParams());
            }
            return AOpenIterator.EMPTY;
        }
    }
}

