/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.IdentityMap;
import org.openl.meta.DoubleValue;
import org.openl.rules.ui.Explanation;

public class Explanator {
    private static ThreadLocal<Explanator> current = new ThreadLocal();
    private static int uniqueId = 0;
    private IdentityMap value2id = new IdentityMap();
    private Map<Integer, Object> id2value = new HashMap<Integer, Object>();
    private Map<String, Explanation> explanators = new HashMap<String, Explanation>();

    public static Explanator getCurrent() {
        return current.get();
    }

    public static void setCurrent(Explanator expl) {
        current.set(expl);
    }

    public DoubleValue find(String expandID) {
        return (DoubleValue)this.id2value.get(new Integer(Integer.parseInt(expandID)));
    }

    public Explanation getExplanation(String rootID) {
        Explanation expl = this.explanators.get(rootID);
        if (expl == null) {
            int id = Integer.parseInt(rootID);
            DoubleValue value = (DoubleValue)this.id2value.get(new Integer(id));
            expl = new Explanation(this);
            expl.root = value;
            this.explanators.put(rootID, expl);
        }
        return expl;
    }

    public int getUniqueId(DoubleValue value) {
        Integer id = (Integer)this.value2id.get((Object)value);
        if (id != null) {
            return id;
        }
        id = new Integer(++uniqueId);
        this.value2id.put((Object)value, (Object)id);
        this.id2value.put(id, value);
        return id;
    }

    public void reset() {
        this.id2value = new HashMap<Integer, Object>();
        this.value2id = new IdentityMap();
        this.explanators = new HashMap<String, Explanation>();
    }
}

