/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeKey;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.MethodKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverloadedMethodsDictionary {
    private Map<MethodKey, Set<TableSyntaxNodeKey>> internalMap = new HashMap<MethodKey, Set<TableSyntaxNodeKey>>();

    public boolean contains(IOpenMethod method) {
        MethodKey key = this.buildKey(method);
        return this.contains(key);
    }

    public void add(TableSyntaxNode table) {
        IOpenMethod method = (IOpenMethod)table.getMember();
        MethodKey key = this.buildKey(method);
        if (this.contains(key)) {
            Set<TableSyntaxNodeKey> value = this.internalMap.get(key);
            value.add(this.buildKey(table));
        } else {
            HashSet<TableSyntaxNodeKey> value = new HashSet<TableSyntaxNodeKey>();
            value.add(this.buildKey(table));
            this.internalMap.put(key, value);
        }
    }

    public void addAll(List<TableSyntaxNode> tables) {
        for (TableSyntaxNode table : tables) {
            this.add(table);
        }
    }

    public Set<TableSyntaxNodeKey> getAllMethodOverloads(IOpenMethod method) {
        MethodKey key = this.buildKey(method);
        return this.internalMap.get(key);
    }

    private boolean contains(MethodKey key) {
        return this.internalMap.containsKey(key);
    }

    private MethodKey buildKey(IOpenMethod method) {
        return new MethodKey(method);
    }

    private TableSyntaxNodeKey buildKey(TableSyntaxNode table) {
        return new TableSyntaxNodeKey(table);
    }
}

