/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import java.util.ArrayList;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.ui.TableSyntaxNodeUtils;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;

public class ProjectHelper {
    private static final String TEST_CASES = "test cases";
    private static final String NO = "No";
    private static final String RUNS = "runs";

    public static IOpenMethod[] allTesters(IOpenClass openClass) {
        ArrayList<IOpenMethod> res = new ArrayList<IOpenMethod>();
        for (IOpenMethod tester : openClass.getMethods()) {
            if (!ProjectHelper.isTester(tester)) continue;
            res.add(tester);
        }
        return res.toArray(new IOpenMethod[0]);
    }

    public static boolean isMethodRunnedBy(IOpenMethod tested, IOpenMethod runner) {
        if (!(runner instanceof TestSuiteMethod)) {
            return false;
        }
        if (runner == tested) {
            return true;
        }
        IOpenMethod toTest = ((TestSuiteMethod)runner).getTestedMethod();
        return toTest == tested && ((TestSuiteMethod)runner).isRunmethod();
    }

    public static boolean isMethodTestedBy(IOpenMethod tested, IOpenMethod tester) {
        if (!(tester instanceof TestSuiteMethod)) {
            return false;
        }
        IOpenMethod toTest = ((TestSuiteMethod)tester).getTestedMethod();
        return toTest == tested && ProjectHelper.isTester(tester);
    }

    public static boolean isRunnable(IOpenMethod m) {
        IOpenClass[] par = m.getSignature().getParameterTypes();
        return par.length == 0;
    }

    public static boolean isTestable(IOpenMethod m) {
        return ProjectHelper.testers(m).length > 0;
    }

    public static boolean isTester(IOpenMethod tester) {
        return tester instanceof TestSuiteMethod && ((TestSuiteMethod)tester).isRunmethodTestable() && ProjectHelper.noErrors((TestSuiteMethod)tester);
    }

    public static boolean noErrors(TestSuiteMethod testMethod) {
        return testMethod.getSyntaxNode().getErrors() == null || testMethod.getSyntaxNode().getErrors().length == 0;
    }

    public static IOpenMethod[] runners(IOpenMethod tested) {
        ArrayList<IOpenMethod> res = new ArrayList<IOpenMethod>();
        for (IOpenMethod runner : tested.getDeclaringClass().getMethods()) {
            if (!ProjectHelper.isMethodRunnedBy(tested, runner)) continue;
            res.add(runner);
        }
        return res.toArray(new IOpenMethod[0]);
    }

    public static IOpenMethod[] testers(IOpenMethod tested) {
        ArrayList<IOpenMethod> res = new ArrayList<IOpenMethod>();
        for (IOpenMethod tester : tested.getDeclaringClass().getMethods()) {
            if (!ProjectHelper.isMethodTestedBy(tested, tester)) continue;
            res.add(tester);
        }
        return res.toArray(new IOpenMethod[0]);
    }

    public static IOpenMethod[] allTesters(IOpenMethod tested) {
        ArrayList<IOpenMethod> res = new ArrayList<IOpenMethod>();
        for (IOpenMethod tester : tested.getDeclaringClass().getMethods()) {
            if (!ProjectHelper.isTestForMethod(tester, tested)) continue;
            res.add(tester);
        }
        return res.toArray(new IOpenMethod[0]);
    }

    private static boolean isTestForMethod(IOpenMethod tester, IOpenMethod tested) {
        if (!(tester instanceof TestSuiteMethod)) {
            return false;
        }
        IOpenMethod toTest = ((TestSuiteMethod)tester).getTestedMethod();
        return toTest == tested;
    }

    public static String createTestName(IOpenMethod testMethod) {
        IMemberMetaInfo mi = testMethod.getInfo();
        TableSyntaxNode tnode = (TableSyntaxNode)mi.getSyntaxNode();
        String name = TableSyntaxNodeUtils.getTableDisplayValue(tnode)[1];
        if (testMethod instanceof TestSuiteMethod) {
            TestSuiteMethod testSuite = (TestSuiteMethod)testMethod;
            name = testSuite.isRunmethod() ? (testSuite.nUnitRuns() < 1 ? name + ProjectHelper.getTestAdditionalInfo(NO, RUNS) : name + ProjectHelper.getNumberOfTests(testSuite.nUnitRuns(), RUNS)) : (testSuite.getNumberOfTests() < 1 ? name + ProjectHelper.getTestAdditionalInfo(NO, TEST_CASES) : name + ProjectHelper.getNumberOfTests(testSuite.getNumberOfTests(), TEST_CASES));
        }
        return name;
    }

    private static String getNumberOfTests(int param1, String param2) {
        return String.format(" (%d %s)", param1, param2);
    }

    private static String getTestAdditionalInfo(String param1, String param2) {
        return String.format(" (%s %s)", param1, param2);
    }
}

