/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.openl.rules.ui.search.FileIndexer;
import org.openl.rules.webstudio.util.WebstudioTreeIterator;
import org.openl.util.FileTypeHelper;
import org.openl.util.Log;

public class ProjectIndexer
extends FileIndexer {
    private String projectRoot;

    public ProjectIndexer(String projectRoot) {
        this.projectRoot = projectRoot;
        this.loadFiles();
    }

    int findMaxPathLength(String path) {
        int idx1 = path.lastIndexOf("bin");
        int idx2 = path.lastIndexOf("classes");
        return Math.max(idx1, idx2);
    }

    synchronized void loadFiles() {
        WebstudioTreeIterator filesTreeIter = new WebstudioTreeIterator(new File(this.projectRoot), 0);
        HashMap<String, String> fileMap = new HashMap<String, String>();
        while (filesTreeIter.hasNext()) {
            File file = (File)filesTreeIter.next();
            String fileName = file.getName();
            if (!FileTypeHelper.isExcelFile((String)fileName) && !FileTypeHelper.isWordFile((String)fileName)) continue;
            try {
                String canonPath = file.getCanonicalPath();
                String fileAlreadyExist = (String)fileMap.get(fileName);
                String preferrablePath = this.selectPreferrablePath(fileAlreadyExist, canonPath);
                fileMap.put(fileName, preferrablePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String[] files = new String[fileMap.size()];
        Iterator it = fileMap.values().iterator();
        for (int i = 0; i < files.length; ++i) {
            files[i] = (String)it.next();
        }
        this.setFiles(files);
    }

    public void reset() {
        this.loadFiles();
    }

    private String selectPreferrablePath(String existingFile, String currentFile) {
        int currentMaxLength;
        if (existingFile == null) {
            return currentFile;
        }
        int existMaxLength = this.findMaxPathLength(existingFile);
        if (existMaxLength == (currentMaxLength = this.findMaxPathLength(currentFile))) {
            Log.warn((Object)("Two files with the same name: \n" + existingFile + "\n" + currentFile));
        }
        return existMaxLength < currentMaxLength ? existingFile : currentFile;
    }
}

