/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.conf.ClassLoaderFactory;
import org.openl.conf.OpenLConfiguration;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessages;
import org.openl.message.Severity;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeAdapter;
import org.openl.rules.lang.xls.syntax.WorkbookSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.project.ModulesCache;
import org.openl.rules.project.instantiation.ReloadType;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.resolving.ResolvingStrategy;
import org.openl.rules.project.resolving.RulesProjectResolver;
import org.openl.rules.search.IOpenLSearch;
import org.openl.rules.search.ISearchTableRow;
import org.openl.rules.search.OpenLAdvancedSearchResult;
import org.openl.rules.search.OpenLAdvancedSearchResultViewer;
import org.openl.rules.search.OpenLBussinessSearchResult;
import org.openl.rules.search.OpenLSavedSearch;
import org.openl.rules.table.CompositeGrid;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IOpenLTable;
import org.openl.rules.table.OpenLTable;
import org.openl.rules.table.ui.FilteredGrid;
import org.openl.rules.table.ui.IGridSelector;
import org.openl.rules.table.ui.RegionGridSelector;
import org.openl.rules.table.ui.filters.ColorGridFilter;
import org.openl.rules.table.ui.filters.IGridFilter;
import org.openl.rules.table.ui.filters.SimpleFormatFilter;
import org.openl.rules.table.xls.XlsCellStyle2;
import org.openl.rules.table.xls.XlsSheetGridHelper;
import org.openl.rules.table.xls.XlsSheetGridImporter;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.XlsUrlParser;
import org.openl.rules.table.xls.XlsUrlUtils;
import org.openl.rules.tableeditor.model.TableEditorModel;
import org.openl.rules.tableeditor.model.ui.TableModel;
import org.openl.rules.tableeditor.model.ui.TableViewer;
import org.openl.rules.tableeditor.renderkit.HTMLRenderer;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.testmethod.TestUnit;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.ui.ColorFilterHolder;
import org.openl.rules.ui.OverloadedMethodsDictionary;
import org.openl.rules.ui.ProjectHelper;
import org.openl.rules.ui.ProjectIndexer;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.ui.tests.results.RanTestsResults;
import org.openl.rules.ui.tests.results.Test;
import org.openl.rules.ui.tree.OpenMethodsGroupTreeNodeBuilder;
import org.openl.rules.ui.tree.ProjectTreeNode;
import org.openl.rules.ui.tree.TreeBuilder;
import org.openl.rules.ui.tree.TreeCache;
import org.openl.rules.ui.tree.TreeNodeBuilder;
import org.openl.rules.validation.properties.dimentional.DispatcherTableBuilder;
import org.openl.rules.workspace.uw.UserWorkspaceProject;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.IBenchmarkableMethod;
import org.openl.util.Log;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.benchmark.Benchmark;
import org.openl.util.benchmark.BenchmarkInfo;
import org.openl.util.benchmark.BenchmarkUnit;
import org.openl.util.export.IExportable;
import org.openl.util.export.IExporter;
import org.openl.util.export.IImporter;
import org.openl.util.tree.ITreeElement;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.SimpleVM;
import org.openl.vm.trace.Tracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectModel {
    private CompiledOpenClass compiledOpenClass;
    private Module moduleInfo;
    private ModulesCache modulesCache = new ModulesCache();
    private ProjectIndexer indexer;
    private WebStudio studio;
    private ColorFilterHolder filterHolder = new ColorFilterHolder();
    private OpenLSavedSearch[] savedSearches;
    private ProjectTreeNode projectRoot = null;
    private TreeCache<String, ITreeElement<?>> idTreeCache = new TreeCache();
    private TreeCache<String, ProjectTreeNode> uriTreeCache = new TreeCache();
    private OpenLMessages previousUsedMessages;

    public ProjectModel(WebStudio studio) {
        this.studio = studio;
    }

    public static TableModel buildModel(IGridTable gt, IGridFilter[] filters) {
        IGrid htmlGrid = gt.getGrid();
        if (!(htmlGrid instanceof FilteredGrid)) {
            int N = 1;
            IGridFilter[] f1 = new IGridFilter[filters == null ? N : filters.length + N];
            f1[0] = new SimpleFormatFilter();
            for (int i = N; i < f1.length; ++i) {
                f1[i] = filters[i - N];
            }
            htmlGrid = new FilteredGrid(gt.getGrid(), f1);
        }
        return new TableViewer(htmlGrid, gt.getRegion()).buildModel(gt);
    }

    public UserWorkspaceProject getProject() {
        return this.studio.getCurrentProject();
    }

    public BenchmarkInfo benchmarkElement(String elementUri, final String testName, String testID, final String testDescr, int ms) throws Exception {
        BenchmarkUnit bu = null;
        if (StringUtils.isBlank((String)testName)) {
            IOpenMethod m = this.getMethod(elementUri);
            return this.benchmarkMethod(m, ms);
        }
        final RanTestsResults atr = this.getRunMethods(elementUri);
        final int tid = Integer.parseInt(testID);
        final IRuntimeEnv env = new SimpleVM().getRuntimeEnv();
        final Object target = this.compiledOpenClass.getOpenClassWithErrors().newInstance(env);
        bu = new BenchmarkUnit(){

            public String getName() {
                return testDescr;
            }

            public void run() throws Exception {
                throw new RuntimeException();
            }

            public void runNtimes(int times) throws Exception {
                try {
                    atr.run(testName, tid, target, env, times);
                }
                catch (Throwable t) {
                    Log.error((Object)"Error during Method run: ", (Throwable)t);
                    throw RuntimeExceptionWrapper.wrap((Throwable)t);
                }
            }

            public String[] unitName() {
                return new String[]{testName + ":" + tid};
            }
        };
        BenchmarkUnit[] buu = new BenchmarkUnit[]{bu};
        return new Benchmark(buu).runUnit(bu, ms, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BenchmarkInfo benchmarkMethod(final IOpenMethod m, int ms) throws Exception {
        final IRuntimeEnv env = new SimpleVM().getRuntimeEnv();
        final Object target = this.compiledOpenClass.getOpenClassWithErrors().newInstance(env);
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.moduleInfo.getProject().getClassLoader(false));
            final Object[] params = new Object[]{};
            BenchmarkUnit bu = null;
            try {
                if (m instanceof IBenchmarkableMethod) {
                    final IBenchmarkableMethod bm = (IBenchmarkableMethod)m;
                    bu = new BenchmarkUnit(){

                        public String getName() {
                            return bm.getBenchmarkName();
                        }

                        public int nUnitRuns() {
                            return bm.nUnitRuns();
                        }

                        protected void run() throws Exception {
                            throw new RuntimeException();
                        }

                        public void runNtimes(int times) throws Exception {
                            bm.invokeBenchmark(target, params, env, times);
                        }

                        public String[] unitName() {
                            return bm.unitName();
                        }
                    };
                } else {
                    bu = new BenchmarkUnit(){

                        public String getName() {
                            return m.getName();
                        }

                        protected void run() throws Exception {
                            m.invoke(target, params, env);
                        }
                    };
                }
                BenchmarkUnit[] buu = new BenchmarkUnit[]{bu};
                BenchmarkInfo benchmarkInfo = new Benchmark(buu).runUnit(bu, ms, false);
                return benchmarkInfo;
            }
            catch (Throwable t) {
                Log.error((Object)"Run Error:", (Throwable)t);
                BenchmarkInfo benchmarkInfo = new BenchmarkInfo(t, bu, bu.getName());
                Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                return benchmarkInfo;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
    }

    private Object convertTestResult(Object res) {
        if (res == null) {
            return null;
        }
        Class<?> clazz = res.getClass();
        if (clazz != TestUnitsResults.class) {
            return res;
        }
        TestUnitsResults tr = (TestUnitsResults)res;
        Object[] unitResults = new Object[tr.getNumberOfTestUnits()];
        int i = 0;
        for (TestUnit testUnit : tr.getTestUnits()) {
            unitResults[i] = testUnit.getActualResult();
            ++i;
        }
        return unitResults;
    }

    public TableSyntaxNode findAnyTableNodeByLocation(XlsUrlParser p1) {
        TableSyntaxNode[] nodes = this.getTableSyntaxNodes();
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].getType().equals(XlsNodeTypes.XLS_DT.toString()) || !XlsUrlUtils.intersectsByLocation((XlsUrlParser)p1, (String)nodes[i].getGridTable().getUri())) continue;
            return nodes[i];
        }
        return null;
    }

    public TableSyntaxNode findNode(String url) {
        XlsUrlParser parsedUrl = new XlsUrlParser();
        parsedUrl.parse(url);
        if (parsedUrl.range == null) {
            return null;
        }
        return this.findNode(parsedUrl);
    }

    public String findTableUri(String partialUri) {
        TableSyntaxNode tableSyntaxNode = this.findNode(partialUri);
        if (tableSyntaxNode != null) {
            return tableSyntaxNode.getUri();
        }
        return null;
    }

    public TableSyntaxNode findNode(XlsUrlParser p1) {
        TableSyntaxNode[] nodes = this.getTableSyntaxNodes();
        for (int i = 0; i < nodes.length; ++i) {
            if (!XlsUrlUtils.intersects((XlsUrlParser)p1, (String)nodes[i].getGridTable().getUri())) continue;
            return nodes[i];
        }
        return null;
    }

    public List<TableSyntaxNode> getAllValidatedNodes() {
        if (this.compiledOpenClass == null) {
            return Collections.emptyList();
        }
        TableSyntaxNode[] nodes = this.getTableSyntaxNodes();
        ArrayList<TableSyntaxNode> list = new ArrayList<TableSyntaxNode>();
        for (int i = 0; i < nodes.length; ++i) {
            TableSyntaxNode tsn = nodes[i];
            if (tsn.getType() != XlsNodeTypes.XLS_DT.toString() || tsn.getErrors() != null || tsn.getTableProperties() == null || !"on".equals(tsn.getTableProperties().getValidateDT())) continue;
            list.add(tsn);
        }
        return list;
    }

    public String getTreeNodeId(ITreeElement<?> treeNode) {
        return this.idTreeCache.getKey(treeNode);
    }

    public String getTreeNodeId(String uri) {
        ProjectTreeNode node = this.uriTreeCache.getNode(uri);
        String nodeId = this.idTreeCache.getKey(node);
        return nodeId;
    }

    public ProjectTreeNode getTreeNodeById(String id) {
        return (ProjectTreeNode)this.idTreeCache.getNode(id);
    }

    public ProjectTreeNode getTreeNodeByUri(String uri) {
        return this.uriTreeCache.getNode(uri);
    }

    public ColorFilterHolder getFilterHolder() {
        return this.filterHolder;
    }

    public ProjectIndexer getIndexer() {
        return this.indexer;
    }

    public IOpenMethod getMethod(String elementUri) {
        TableSyntaxNode tsn = this.getNode(elementUri);
        if (tsn == null) {
            return null;
        }
        return this.getMethod(tsn);
    }

    public List<IOpenMethod> getTargetMethods(String testOrRunUri) {
        ArrayList<IOpenMethod> targetMethods = new ArrayList<IOpenMethod>();
        IOpenMethod testMethod = this.getMethod(testOrRunUri);
        if (testMethod instanceof TestSuiteMethod) {
            IOpenMethod targetMethod = ((TestSuiteMethod)testMethod).getTestedMethod();
            if (targetMethod instanceof OpenMethodDispatcher) {
                List overloadedMethods = ((OpenMethodDispatcher)targetMethod).getCandidates();
                targetMethods.addAll(overloadedMethods);
            } else {
                targetMethods.add(targetMethod);
            }
        }
        return targetMethods;
    }

    public List<IOpenLTable> getTargetTables(String testOrRunUri) {
        ArrayList<IOpenLTable> targetTables = new ArrayList<IOpenLTable>();
        List<IOpenMethod> targetMethods = this.getTargetMethods(testOrRunUri);
        for (IOpenMethod targetMethod : targetMethods) {
            if (targetMethod == null) continue;
            TableSyntaxNode tsn = (TableSyntaxNode)targetMethod.getInfo().getSyntaxNode();
            TableSyntaxNodeAdapter targetTable = new TableSyntaxNodeAdapter(tsn);
            targetTables.add((IOpenLTable)targetTable);
        }
        return targetTables;
    }

    public IOpenMethod getMethod(TableSyntaxNode tsn) {
        if (!this.isProjectCompiledSuccessfully()) {
            return null;
        }
        IOpenClass openClass = this.compiledOpenClass.getOpenClassWithErrors();
        for (IOpenMethod method : openClass.getMethods()) {
            IOpenMethod resolvedMethod = null;
            resolvedMethod = method instanceof OpenMethodDispatcher ? this.resolveMethodDispatcher((OpenMethodDispatcher)method, tsn) : this.resolveMethod(method, tsn);
            if (resolvedMethod == null) continue;
            return resolvedMethod;
        }
        return null;
    }

    private IOpenMethod resolveMethodDispatcher(OpenMethodDispatcher method, TableSyntaxNode syntaxNode) {
        List candidates = method.getCandidates();
        for (IOpenMethod candidate : candidates) {
            IOpenMethod resolvedMethod = this.resolveMethod(candidate, syntaxNode);
            if (resolvedMethod == null) continue;
            return method;
        }
        return null;
    }

    private IOpenMethod resolveMethod(IOpenMethod method, TableSyntaxNode syntaxNode) {
        if (this.isInstanceOfTable(method, syntaxNode)) {
            return method;
        }
        return null;
    }

    private boolean isInstanceOfTable(IOpenMethod method, TableSyntaxNode syntaxNode) {
        IMemberMetaInfo metaInfo = method.getInfo();
        return metaInfo != null && metaInfo.getSyntaxNode() == syntaxNode;
    }

    public TableSyntaxNode getNode(String elementUri) {
        TableSyntaxNode tsn = null;
        if (elementUri != null) {
            ProjectTreeNode pte = this.getTreeNodeByUri(elementUri);
            if (pte != null) {
                tsn = (TableSyntaxNode)pte.getObject();
            }
            if (tsn == null) {
                tsn = this.findNode(elementUri);
            }
        }
        return tsn;
    }

    public synchronized ITreeElement<?> getProjectTree() {
        if (this.projectRoot == null) {
            this.buildProjectTree();
        }
        return this.projectRoot;
    }

    public RanTestsResults getRunMethods(String elementUri) {
        IOpenMethod m = this.getMethod(elementUri);
        if (m == null) {
            return null;
        }
        IOpenMethod[] runners = ProjectHelper.runners(m);
        String[] names = new String[runners.length];
        for (int i = 0; i < runners.length; ++i) {
            names[i] = ProjectHelper.createTestName(runners[i]);
        }
        return new RanTestsResults(runners, names);
    }

    public OpenLSavedSearch[] getSavedSearches() {
        if (this.savedSearches == null && this.isReady()) {
            TableSyntaxNode[] nodes = this.getTableSyntaxNodes();
            ArrayList<OpenLSavedSearch> savedSearches = new ArrayList<OpenLSavedSearch>();
            for (TableSyntaxNode node : nodes) {
                if (!node.getType().equals(XlsNodeTypes.XLS_PERSISTENT.toString())) continue;
                String code = node.getHeader().getModule().getCode();
                if (!("Persistent " + OpenLSavedSearch.class.getName()).equals(code)) continue;
                OpenLSavedSearch savedSearch = new OpenLSavedSearch().restore((IImporter)new XlsSheetGridImporter((XlsSheetGridModel)node.getGridTable().getGrid(), node));
                savedSearches.add(savedSearch);
            }
            this.savedSearches = savedSearches.toArray(new OpenLSavedSearch[savedSearches.size()]);
        }
        return this.savedSearches;
    }

    public List<IOpenLTable> getAdvancedSearchResults(Object searchResult) {
        ArrayList<IOpenLTable> searchResults = new ArrayList<IOpenLTable>();
        if (searchResult instanceof OpenLAdvancedSearchResult) {
            OpenLAdvancedSearchResult.TableAndRows[] tr = ((OpenLAdvancedSearchResult)searchResult).getFoundTableAndRows();
            OpenLAdvancedSearchResultViewer searchViewer = new OpenLAdvancedSearchResultViewer();
            for (int i = 0; i < tr.length; ++i) {
                ISearchTableRow[] rows = tr[i].getRows();
                if (rows.length <= 0) continue;
                TableSyntaxNode tsn = tr[i].getTsn();
                String tableUri = tsn.getUri();
                CompositeGrid cg = searchViewer.makeGrid(rows);
                IGridTable gridTable = cg != null ? cg.asGridTable() : null;
                OpenLTable newTable = new OpenLTable();
                newTable.setGridTable(gridTable);
                newTable.setUri(tableUri);
                newTable.setProperties(tsn.getTableProperties());
                searchResults.add((IOpenLTable)newTable);
            }
        }
        return searchResults;
    }

    public List<IOpenLTable> getBussinessSearchResults(Object searchResult) {
        ArrayList<IOpenLTable> searchResults = new ArrayList<IOpenLTable>();
        if (searchResult instanceof OpenLBussinessSearchResult) {
            List foundTables = ((OpenLBussinessSearchResult)searchResult).getFoundTables();
            for (TableSyntaxNode foundTable : foundTables) {
                searchResults.add((IOpenLTable)new TableSyntaxNodeAdapter(foundTable));
            }
        }
        return searchResults;
    }

    public WebStudio getStudio() {
        return this.studio;
    }

    public IOpenLTable getTable(String elementUri) {
        TableSyntaxNode tsn = this.getNode(elementUri);
        if (tsn != null) {
            return new TableSyntaxNodeAdapter(tsn);
        }
        return null;
    }

    public IGridTable getGridTable(String elementUri) {
        TableSyntaxNode tsn = this.getNode(elementUri);
        return tsn == null ? null : tsn.getGridTable();
    }

    public String getTableView(String view) {
        return view == null ? this.studio.getMode().getTableMode() : view;
    }

    public RanTestsResults getTestsRunner(IOpenMethod[] testMethods) {
        String[] names = new String[testMethods.length];
        for (int i = 0; i < testMethods.length; ++i) {
            names[i] = ProjectHelper.createTestName(testMethods[i]);
        }
        return new RanTestsResults(testMethods, names);
    }

    public RanTestsResults getTestMethods(String elementUri) {
        Object[] testMethods = null;
        IOpenMethod method = this.getMethod(elementUri);
        if (method != null && ArrayUtils.isNotEmpty((Object[])(testMethods = ProjectHelper.isTester(method) ? new IOpenMethod[]{method} : ProjectHelper.testers(method)))) {
            return this.getTestsRunner((IOpenMethod[])testMethods);
        }
        return null;
    }

    public RanTestsResults getAllTestMethods(String elementUri) {
        Object[] testMethods = null;
        IOpenMethod method = this.getMethod(elementUri);
        if (method != null && ArrayUtils.isNotEmpty((Object[])(testMethods = ProjectHelper.allTesters(method)))) {
            return this.getTestsRunner((IOpenMethod[])testMethods);
        }
        return null;
    }

    public RanTestsResults getAllTestMethods() {
        if (this.isProjectCompiledSuccessfully()) {
            IOpenMethod[] testMethods = ProjectHelper.allTesters(this.compiledOpenClass.getOpenClassWithErrors());
            return this.getTestsRunner(testMethods);
        }
        return null;
    }

    private WorkbookSyntaxNode[] getWorkbookNodes() {
        if (!this.isProjectCompiledSuccessfully()) {
            return null;
        }
        if (this.compiledOpenClass != null) {
            XlsModuleSyntaxNode xlsModuleNode = ((XlsMetaInfo)this.compiledOpenClass.getOpenClassWithErrors().getMetaInfo()).getXlsModuleNode();
            WorkbookSyntaxNode[] workbookNodes = xlsModuleNode.getWorkbookSyntaxNodes();
            return workbookNodes;
        }
        return null;
    }

    public boolean isSourceModified() {
        WorkbookSyntaxNode[] workbookNodes = this.getWorkbookNodes();
        if (workbookNodes != null) {
            for (WorkbookSyntaxNode node : workbookNodes) {
                if (!node.getWorkbookSourceCodeModule().isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public CompiledOpenClass getCompiledOpenClass() {
        return this.compiledOpenClass;
    }

    public Module getModuleInfo() {
        return this.moduleInfo;
    }

    public XlsModuleSyntaxNode getXlsModuleNode() {
        if (!this.isProjectCompiledSuccessfully()) {
            return null;
        }
        XlsMetaInfo xmi = (XlsMetaInfo)this.compiledOpenClass.getOpenClassWithErrors().getMetaInfo();
        XlsModuleSyntaxNode xsn = xmi.getXlsModuleNode();
        return xsn;
    }

    public boolean isEditable() {
        UserWorkspaceProject project = this.getProject();
        if (project != null) {
            return project.isCheckedOut() || project.isLocalOnly();
        }
        return false;
    }

    public boolean isReady() {
        return this.compiledOpenClass != null;
    }

    public boolean isRunnable(String elementUri) {
        IOpenMethod m = this.getMethod(elementUri);
        if (m == null) {
            return false;
        }
        return ProjectHelper.isRunnable(m);
    }

    public boolean isTestable(String elementUri) {
        IOpenMethod m = this.getMethod(elementUri);
        if (m == null) {
            return false;
        }
        return ProjectHelper.isTestable(m);
    }

    public boolean isTestable(TableSyntaxNode tsn) {
        IOpenMethod m = this.getMethod(tsn);
        if (m == null) {
            return false;
        }
        return ProjectHelper.isTestable(m);
    }

    public synchronized void buildProjectTree() {
        int i;
        TreeNodeBuilder<Object>[] treeSorters;
        if (this.compiledOpenClass == null) {
            return;
        }
        ProjectTreeNode root = this.makeProjectTreeRoot();
        TableSyntaxNode[] tableSyntaxNodes = this.getTableSyntaxNodes();
        OverloadedMethodsDictionary methodNodesDictionary = this.makeMethodNodesDictionary(tableSyntaxNodes);
        TreeBuilder<Object> treeBuilder = new TreeBuilder<Object>();
        for (TreeNodeBuilder<Object> treeSorter : treeSorters = this.studio.getMode().getBuilders()) {
            if (!(treeSorter instanceof OpenMethodsGroupTreeNodeBuilder)) continue;
            OpenMethodsGroupTreeNodeBuilder tableTreeNodeBuilder = (OpenMethodsGroupTreeNodeBuilder)treeSorter;
            tableTreeNodeBuilder.setOpenMethodGroupsDictionary(methodNodesDictionary);
        }
        HashSet<TableSyntaxNode> nodesWithErrors = new HashSet<TableSyntaxNode>();
        boolean treeEnlarged = false;
        for (i = 0; i < tableSyntaxNodes.length; ++i) {
            if (this.studio.getMode().select(tableSyntaxNodes[i])) {
                treeBuilder.addToNode(root, tableSyntaxNodes[i], treeSorters);
                treeEnlarged = true;
                continue;
            }
            if (XlsNodeTypes.XLS_PROPERTIES.toString().equals(tableSyntaxNodes[i].getType())) {
                treeBuilder.addToNode(root, tableSyntaxNodes[i], treeSorters);
                continue;
            }
            if (tableSyntaxNodes[i].getErrors() == null || DispatcherTableBuilder.isDispatcherTable((TableSyntaxNode)tableSyntaxNodes[i])) continue;
            treeBuilder.addToNode(root, tableSyntaxNodes[i], treeSorters);
            nodesWithErrors.add(tableSyntaxNodes[i]);
        }
        if (!treeEnlarged) {
            for (i = 0; i < tableSyntaxNodes.length; ++i) {
                if (XlsNodeTypes.XLS_OTHER.toString().equals(tableSyntaxNodes[i].getType()) || XlsNodeTypes.XLS_PROPERTIES.toString().equals(tableSyntaxNodes[i].getType()) || nodesWithErrors.contains(tableSyntaxNodes[i])) continue;
                treeBuilder.addToNode(root, tableSyntaxNodes[i], treeSorters);
            }
        }
        this.projectRoot = root;
        this.uriTreeCache.clear();
        this.idTreeCache.clear();
        this.cacheTree(this.projectRoot);
    }

    private TableSyntaxNode[] getTableSyntaxNodes() {
        if (this.isProjectCompiledSuccessfully()) {
            XlsModuleSyntaxNode moduleSyntaxNode = this.getXlsModuleNode();
            TableSyntaxNode[] tableSyntaxNodes = moduleSyntaxNode.getXlsTableSyntaxNodes();
            return tableSyntaxNodes;
        }
        return new TableSyntaxNode[0];
    }

    private void cacheTree(String key, ProjectTreeNode treeNode) {
        int childNumber = 0;
        Iterator iterator = treeNode.getChildren();
        while (iterator.hasNext()) {
            ProjectTreeNode child = (ProjectTreeNode)iterator.next();
            if (child.getType().startsWith("table.")) {
                ProjectTreeNode ptr = child;
                this.uriTreeCache.put(ptr.getUri(), ptr);
            }
            String childKey = (StringUtils.isNotBlank((String)key) ? key + ":" : "") + (childNumber + 1);
            this.idTreeCache.put(childKey, child);
            ++childNumber;
            this.cacheTree(childKey, child);
        }
    }

    private void cacheTree(ProjectTreeNode treeNode) {
        this.cacheTree(null, treeNode);
    }

    private OverloadedMethodsDictionary makeMethodNodesDictionary(TableSyntaxNode[] tableSyntaxNodes) {
        List<TableSyntaxNode> executableNodes = this.getAllExecutableTables(tableSyntaxNodes);
        OverloadedMethodsDictionary methodNodesDictionary = new OverloadedMethodsDictionary();
        methodNodesDictionary.addAll(executableNodes);
        return methodNodesDictionary;
    }

    private ProjectTreeNode makeProjectTreeRoot() {
        String name = this.studio.getMode().getDisplayName(this.moduleInfo);
        return new ProjectTreeNode(new String[]{name, name, name}, "root", null, null, 0, null);
    }

    private List<TableSyntaxNode> getAllExecutableTables(TableSyntaxNode[] nodes) {
        ArrayList<TableSyntaxNode> executableNodes = new ArrayList<TableSyntaxNode>();
        for (TableSyntaxNode node : nodes) {
            if (!(node.getMember() instanceof IOpenMethod)) continue;
            executableNodes.add(node);
        }
        return executableNodes;
    }

    public void redraw() throws Exception {
        this.projectRoot = null;
    }

    public void reset(ReloadType reloadType) throws Exception {
        switch (reloadType) {
            case FORCED: {
                OpenL.reset();
                OpenLConfiguration.reset();
                ClassLoaderFactory.reset();
            }
            case RELOAD: {
                this.modulesCache.reset();
            }
        }
        this.setModuleInfo(this.moduleInfo, reloadType);
        this.savedSearches = null;
        this.projectRoot = null;
    }

    public RanTestsResults testAll(String elementUri) {
        RanTestsResults testsRunner = this.getTestMethods(elementUri);
        if (testsRunner == null) {
            testsRunner = this.getAllTestMethods();
        }
        Test[] tests = testsRunner.getTests();
        TestUnitsResults[] testResults = new TestUnitsResults[tests.length];
        for (int i = 0; i < testResults.length; ++i) {
            testResults[i] = (TestUnitsResults)this.runMethod((IOpenMethod)tests[i].getMethod());
        }
        testsRunner.setResults(testResults);
        return testsRunner;
    }

    public RanTestsResults testUnit(String testUri, String testName, String unitIdStr) {
        RanTestsResults testsRunner = this.getTestMethods(testUri);
        if (testsRunner != null) {
            Test[] ttm = testsRunner.getTests();
            int unitId = Integer.parseInt(unitIdStr);
            Test testUnit = ttm[0];
            TestUnitsResults[] ttr = new TestUnitsResults[ttm.length];
            ttr[0] = (TestUnitsResults)this.runTestUnit(testUnit.getMethod(), unitId);
            testsRunner.setResults(ttr);
        }
        return testsRunner;
    }

    public Object runElement(String elementUri, String testName, String testID) {
        if (!this.isProjectCompiledSuccessfully()) {
            return null;
        }
        if (testName == null) {
            IOpenMethod m = this.getMethod(elementUri);
            return this.convertTestResult(this.runMethod(m));
        }
        RanTestsResults testsRunner = this.getRunMethods(elementUri);
        int tid = Integer.parseInt(testID);
        IRuntimeEnv env = new SimpleVM().getRuntimeEnv();
        Object target = this.compiledOpenClass.getOpenClassWithErrors().newInstance(env);
        try {
            Object res = testsRunner.run(testName, tid, target, env, 1);
            return res;
        }
        catch (Throwable t) {
            Log.error((Object)"Error during Method run: ", (Throwable)t);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runMethod(IOpenMethod m) {
        if (!this.isProjectCompiledSuccessfully()) {
            return null;
        }
        IRuntimeEnv env = new SimpleVM().getRuntimeEnv();
        Object target = this.compiledOpenClass.getOpenClassWithErrors().newInstance(env);
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.moduleInfo.getProject().getClassLoader(false));
            Object res = null;
            try {
                res = m.invoke(target, new Object[0], env);
            }
            catch (Throwable t) {
                Log.error((Object)"Run Error:", (Throwable)t);
                Throwable throwable = t;
                Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                return throwable;
            }
            Object object = res;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runTestUnit(TestSuiteMethod m, int unitId) {
        if (!this.isProjectCompiledSuccessfully()) {
            return null;
        }
        IRuntimeEnv env = new SimpleVM().getRuntimeEnv();
        Object target = this.compiledOpenClass.getOpenClassWithErrors().newInstance(env);
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.moduleInfo.getProject().getClassLoader(false));
            Object res = null;
            try {
                res = m.invoke(target, new Object[0], env, unitId);
            }
            catch (Throwable t) {
                Log.error((Object)"Run Error:", (Throwable)t);
                Throwable throwable = t;
                Thread.currentThread().setContextClassLoader(currentContextClassLoader);
                return throwable;
            }
            Object object = res;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
    }

    public Object runSearch(IOpenLSearch searchBean) {
        XlsModuleSyntaxNode xsn = this.getXlsModuleNode();
        return searchBean.search(xsn);
    }

    public void saveSearch(OpenLSavedSearch search) throws Exception {
        XlsWorkbookSourceCodeModule module = this.getWorkbookNodes()[0].getWorkbookSourceCodeModule();
        if (module != null) {
            IExporter iExporter = XlsSheetGridHelper.createExporter((XlsWorkbookSourceCodeModule)module);
            iExporter.persist((IExportable)search);
            module.save();
            this.reset(ReloadType.SINGLE);
        }
    }

    public void setProjectTree(ProjectTreeNode projectRoot) {
        this.projectRoot = projectRoot;
    }

    public void setModuleInfo(Module moduleInfo) throws Exception {
        this.setModuleInfo(moduleInfo, ReloadType.NO);
    }

    public void setModuleInfo(Module moduleInfo, ReloadType reloadType) throws Exception {
        if (this.moduleInfo == moduleInfo && reloadType == ReloadType.NO) {
            return;
        }
        File projectFolder = moduleInfo.getProject().getProjectFolder();
        if (reloadType == ReloadType.FORCED) {
            RulesProjectResolver projectResolver = this.studio.getProjectResolver();
            ResolvingStrategy resolvingStrategy = projectResolver.isRulesProject(projectFolder);
            this.moduleInfo = resolvingStrategy.resolveProject(projectFolder).getModuleByClassName(moduleInfo.getClassname());
        } else {
            this.moduleInfo = moduleInfo;
        }
        this.indexer = new ProjectIndexer(projectFolder.getAbsolutePath());
        this.clearOpenLMessages();
        this.compiledOpenClass = null;
        this.projectRoot = null;
        this.savedSearches = null;
        if (reloadType != ReloadType.NO) {
            XlsCellStyle2.cleareThemesCache();
        }
        RulesInstantiationStrategy instantiationStrategy = this.modulesCache.getInstantiationStrategy(moduleInfo);
        try {
            this.compiledOpenClass = instantiationStrategy.compile(reloadType);
        }
        catch (Throwable t) {
            Log.error((Object)"Problem Loading OpenLWrapper", (Throwable)t);
            String message = StringUtils.join((Object[])new String[]{"Cannot load the module", ":", t.getMessage()});
            ArrayList<OpenLMessage> messages = new ArrayList<OpenLMessage>();
            messages.add(new OpenLMessage(message, "", Severity.ERROR));
            this.compiledOpenClass = new CompiledOpenClass((IOpenClass)NullOpenClass.the, messages, new SyntaxNodeException[0], new SyntaxNodeException[0]);
        }
    }

    private void clearOpenLMessages() {
        if (this.previousUsedMessages != null) {
            this.previousUsedMessages.clear();
        }
        this.previousUsedMessages = OpenLMessages.getCurrentInstance();
    }

    public String showTableWithSelection(String url, String view) {
        TableSyntaxNode tsn = this.findNode(url);
        if (tsn == null) {
            return "NOT FOUND";
        }
        XlsUrlParser p1 = new XlsUrlParser();
        p1.parse(url);
        IGridRegion region = IGridRegion.Tool.makeRegion((String)p1.range);
        if (view == null) {
            view = "view.business";
        }
        ILogicalTable gtx = (ILogicalTable)tsn.getSubTables().get(view);
        IGridTable gt = tsn.getGridTable();
        if (gtx != null) {
            gt = gtx.getSource();
        }
        TableModel tableModel = ProjectModel.buildModel(gt, new IGridFilter[]{new ColorGridFilter((IGridSelector)new RegionGridSelector(region, true), this.filterHolder.makeFilter())});
        return new HTMLRenderer.TableRenderer(tableModel).render(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer traceElement(String elementUri, String testName, String testID) {
        Tracer t = new Tracer();
        Tracer.setTracer((Tracer)t);
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.moduleInfo.getProject().getClassLoader(false));
            try {
                this.runElement(elementUri, testName, testID);
            }
            finally {
                Tracer.setTracer(null);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
        return t;
    }

    public TableEditorModel getTableEditorModel(String tableUri) {
        IOpenLTable table = this.getTable(tableUri);
        String tableView = this.getTableView(null);
        TableEditorModel tableModel = new TableEditorModel(table, tableView, false);
        return tableModel;
    }

    @Deprecated
    public static String showTable(IGridTable gt, boolean showgrid) {
        return ProjectModel.showTable(gt, null, showgrid);
    }

    @Deprecated
    public static String showTable(IGridTable gt, IGridFilter[] filters, boolean showgrid) {
        TableModel model = ProjectModel.buildModel(gt, filters);
        return TableViewer.showTable((TableModel)model, (boolean)showgrid);
    }

    public boolean isProjectCompiledSuccessfully() {
        return this.compiledOpenClass != null && this.compiledOpenClass.getOpenClassWithErrors() != null && !(this.compiledOpenClass.getOpenClassWithErrors() instanceof NullOpenClass);
    }
}

