/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import org.apache.commons.lang.StringUtils;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.ui.OverloadedMethodsDictionary;
import org.openl.types.IOpenMethod;

public class TableSyntaxNodeUtils {
    private static final String DISPLAY_TABLE_PROPERTY_NAME = "display";

    public static String[] getTableDisplayValue(TableSyntaxNode tableSyntaxNode) {
        return TableSyntaxNodeUtils.getTableDisplayValue(tableSyntaxNode, 0);
    }

    public static String[] getTableDisplayValue(TableSyntaxNode tableSyntaxNode, int i) {
        return TableSyntaxNodeUtils.getTableDisplayValue(tableSyntaxNode, i, null);
    }

    public static String[] getTableDisplayValue(TableSyntaxNode tableSyntaxNode, int i, OverloadedMethodsDictionary dictionary) {
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        String display = null;
        String name = null;
        if (tableProperties != null) {
            name = tableProperties.getName();
            display = tableProperties.getPropertyValueAsString(DISPLAY_TABLE_PROPERTY_NAME);
            if (display == null) {
                display = name;
            }
        }
        if (name == null) {
            name = TableSyntaxNodeUtils.str2name(tableSyntaxNode.getGridTable().getCell(0, 0).getStringValue(), tableSyntaxNode.getType());
        }
        if (display == null) {
            display = TableSyntaxNodeUtils.str2display(tableSyntaxNode.getGridTable().getCell(0, 0).getStringValue(), tableSyntaxNode.getType());
        }
        String sfx = i < 2 ? "" : " (" + i + ")";
        String dimensionInfo = "";
        if (dictionary != null && tableProperties != null && tableSyntaxNode.getMember() instanceof IOpenMethod && dictionary.contains((IOpenMethod)tableSyntaxNode.getMember())) {
            String[] dimensionalPropertyNames;
            for (String dimensionalPropertyName : dimensionalPropertyNames = TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames()) {
                String value = tableProperties.getPropertyValueAsString(dimensionalPropertyName);
                if (StringUtils.isEmpty((String)value)) continue;
                String propertyInfo = StringUtils.join((Object[])new Object[]{dimensionalPropertyName, "=", value});
                dimensionInfo = StringUtils.join((Object[])new Object[]{dimensionInfo, StringUtils.isEmpty((String)dimensionInfo) ? "" : ", ", propertyInfo});
            }
        }
        if (!StringUtils.isEmpty((String)dimensionInfo)) {
            sfx = StringUtils.join((Object[])new Object[]{sfx, StringUtils.isEmpty((String)sfx) ? "" : " ", "[", dimensionInfo, "]"});
        }
        return new String[]{name + sfx, display + sfx, display + sfx};
    }

    private static String str2display(String src, String type) {
        return src;
    }

    public static String str2name(String src, String type) {
        if (src == null) {
            src = "NO NAME";
        } else if (type.equals(XlsNodeTypes.XLS_DATATYPE.toString())) {
            String[] tokens = StringUtils.split((String)src.replaceAll("\\(.*\\)", ""));
            src = tokens[1].trim();
        } else if (type.equals(XlsNodeTypes.XLS_DT.toString()) || type.equals(XlsNodeTypes.XLS_SPREADSHEET.toString()) || type.equals(XlsNodeTypes.XLS_TBASIC.toString()) || type.equals(XlsNodeTypes.XLS_COLUMN_MATCH.toString()) || type.equals(XlsNodeTypes.XLS_DATA.toString()) || type.equals(XlsNodeTypes.XLS_DATATYPE.toString()) || type.equals(XlsNodeTypes.XLS_METHOD.toString()) || type.equals(XlsNodeTypes.XLS_TEST_METHOD.toString()) || type.equals(XlsNodeTypes.XLS_RUN_METHOD.toString())) {
            String[] tokens = StringUtils.split((String)src.replaceAll("\\(.*\\)", ""));
            src = tokens[tokens.length - 1].trim();
        }
        return src;
    }

    public static boolean isAutoGeneratedTable(TableSyntaxNode tsn) {
        return tsn.getMember() instanceof IOpenMethod && ((IOpenMethod)tsn.getMember()).getName().startsWith("validateGapOverlap");
    }
}

