/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeAdapter;
import org.openl.rules.table.ATableTracerNode;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ITableTracerObject;
import org.openl.rules.table.ui.IGridSelector;
import org.openl.rules.table.ui.RegionGridSelector;
import org.openl.rules.table.ui.filters.ColorGridFilter;
import org.openl.rules.table.ui.filters.IGridFilter;
import org.openl.rules.tableeditor.model.ui.TableModel;
import org.openl.rules.tableeditor.renderkit.HTMLRenderer;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.ui.tree.TreeCache;
import org.openl.util.tree.ITreeElement;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.Tracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceHelper {
    private TreeCache<Integer, ITreeElement<?>> traceTreeCache = new TreeCache();
    private int treeElementsNumber = 0;

    private void fillRegions(ITableTracerObject tto, List<IGridRegion> regions) {
        for (ITableTracerObject child : tto.getTableTracers()) {
            List r = child.getGridRegions();
            if (CollectionUtils.isNotEmpty((Collection)r)) {
                regions.addAll(r);
                continue;
            }
            if (child.isLeaf()) continue;
            this.fillRegions(child, regions);
        }
    }

    public ITableTracerObject getTableTracer(int elementID) {
        ITracerObject tt = (ITracerObject)this.traceTreeCache.getNode(elementID);
        if (!(tt instanceof ITableTracerObject)) {
            return null;
        }
        return (ITableTracerObject)tt;
    }

    public String getTracerUri(int elementID) {
        ITableTracerObject tto = this.getTableTracer(elementID);
        if (tto != null) {
            TableSyntaxNode tsn = tto.getTableSyntaxNode();
            return tsn.getUri();
        }
        return null;
    }

    public String getTracerName(int elementID) {
        ITableTracerObject tto = this.getTableTracer(elementID);
        String displayName = null;
        if (tto != null) {
            displayName = tto instanceof ATableTracerNode ? tto.getDisplayName(1) : tto.getParent().getDisplayName(1) + ": " + tto.getDisplayName(1);
        }
        return displayName;
    }

    public Throwable getTracerError(int elementID) {
        ITableTracerObject tracer = this.getTableTracer(elementID);
        Throwable error = null;
        if (tracer != null && tracer instanceof ATableTracerNode) {
            error = ((ATableTracerNode)tracer).getError();
        }
        return error;
    }

    IGridFilter makeFilter(ITableTracerObject tto, ProjectModel model) {
        ArrayList<IGridRegion> regions = new ArrayList<IGridRegion>();
        List r = tto.getGridRegions();
        if (CollectionUtils.isNotEmpty((Collection)r)) {
            regions.addAll(r);
        } else {
            this.fillRegions(tto, regions);
        }
        IGridRegion[] aRegions = new IGridRegion[regions.size()];
        aRegions = regions.toArray(aRegions);
        return new ColorGridFilter((IGridSelector)new RegionGridSelector(aRegions, true), model.getFilterHolder().makeFilter());
    }

    public ITreeElement<?> getTraceTree(Tracer tracer) {
        ITracerObject tree = tracer.getRoot();
        this.cleanCachedTree();
        this.cacheTree((ITreeElement<?>)tree);
        return tree;
    }

    private void cleanCachedTree() {
        this.traceTreeCache.clear();
        this.treeElementsNumber = 0;
    }

    private void cacheTree(ITreeElement<?> treeNode) {
        Iterator iterator = treeNode.getChildren();
        while (iterator.hasNext()) {
            ITreeElement child = (ITreeElement)iterator.next();
            this.traceTreeCache.put(this.treeElementsNumber++, child);
            this.cacheTree(child);
        }
    }

    public int getNodeKey(ITreeElement<?> node) {
        return this.traceTreeCache.getKey(node);
    }

    public String showTrace(int id, ProjectModel model, String view) {
        ITracerObject tt = (ITracerObject)this.traceTreeCache.getNode(id);
        if (tt == null) {
            return "ERROR ID = " + id;
        }
        if (!(tt instanceof ITableTracerObject)) {
            return "----";
        }
        ITableTracerObject tto = (ITableTracerObject)tt;
        TableSyntaxNode tsn = tto.getTableSyntaxNode();
        TableSyntaxNodeAdapter table = new TableSyntaxNodeAdapter(tsn);
        IGridTable gt = table.getGridTable(view);
        TableModel tableModel = ProjectModel.buildModel(gt, new IGridFilter[]{this.makeFilter(tto, model)});
        return new HTMLRenderer.TableRenderer(tableModel).render(false);
    }
}

