/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.project.instantiation.ReloadType;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.RulesProjectResolver;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.ui.TraceHelper;
import org.openl.rules.ui.WebStudioProperties;
import org.openl.rules.ui.view.BusinessViewMode1;
import org.openl.rules.ui.view.BusinessViewMode2;
import org.openl.rules.ui.view.BusinessViewMode3;
import org.openl.rules.ui.view.DeveloperByFileViewMode;
import org.openl.rules.ui.view.DeveloperByTypeViewMode;
import org.openl.rules.ui.view.WebStudioViewMode;
import org.openl.rules.webstudio.web.repository.RepositoryTreeState;
import org.openl.rules.webstudio.web.servlet.RulesUserSession;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.rules.workspace.WorkspaceException;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.uw.UserWorkspace;
import org.openl.rules.workspace.uw.UserWorkspaceProject;
import org.openl.util.benchmark.BenchmarkInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebStudio {
    private static final Log LOG = LogFactory.getLog(WebStudio.class);
    public static final String TRACER_NAME = "tracer";
    private WebStudioViewMode DEVELOPER_BYTYPE_VIEW = new DeveloperByTypeViewMode();
    private WebStudioViewMode DEVELOPER_BYFILE_VIEW = new DeveloperByFileViewMode();
    private WebStudioViewMode BUSINESS1_VIEW = new BusinessViewMode1();
    private WebStudioViewMode BUSINESS2_VIEW = new BusinessViewMode2();
    private WebStudioViewMode BUSINESS3_VIEW = new BusinessViewMode3();
    private WebStudioViewMode[] businessModes = new WebStudioViewMode[]{this.BUSINESS1_VIEW, this.BUSINESS2_VIEW, this.BUSINESS3_VIEW};
    private WebStudioViewMode[] developerModes = new WebStudioViewMode[]{this.DEVELOPER_BYTYPE_VIEW, this.DEVELOPER_BYFILE_VIEW};
    private String workspacePath;
    private ArrayList<BenchmarkInfo> benchmarks = new ArrayList();
    private List<StudioListener> listeners = new ArrayList<StudioListener>();
    private String tableUri;
    private ProjectModel model = new ProjectModel(this);
    private RulesProjectResolver projectResolver;
    private List<ProjectDescriptor> projects = null;
    private WebStudioViewMode mode = this.BUSINESS1_VIEW;
    private Module currentModule;
    private boolean showFormulas;
    private boolean collapseProperties = true;
    private WebStudioProperties properties = new WebStudioProperties();
    private int businessModeIdx = 0;
    private int developerModeIdx = 0;

    public WebStudio(HttpSession session) {
        boolean initialized = false;
        try {
            initialized = this.init(session);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!initialized) {
            this.workspacePath = System.getProperty("openl.webstudio.home") == null ? ".." : System.getProperty("openl.webstudio.home");
            this.projectResolver = RulesProjectResolver.loadProjectResolverFromClassPath();
            this.projectResolver.setWorkspace(this.workspacePath);
        }
    }

    public WebStudio() {
        this(FacesUtils.getSession());
    }

    public boolean init(HttpSession session) {
        UserWorkspace userWorkspace;
        try {
            RulesUserSession rulesUserSession = WebStudioUtils.getRulesUserSession(session, true);
            userWorkspace = rulesUserSession.getUserWorkspace();
        }
        catch (WorkspaceException e) {
            LOG.error((Object)"Failed to get user workspace", (Throwable)e);
            return false;
        }
        catch (ProjectException e) {
            LOG.error((Object)"Failed to get user workspace", (Throwable)e);
            return false;
        }
        if (userWorkspace == null) {
            return false;
        }
        this.workspacePath = userWorkspace.getLocalWorkspaceLocation().getAbsolutePath();
        this.projectResolver = RulesProjectResolver.loadProjectResolverFromClassPath();
        this.projectResolver.setWorkspace(this.workspacePath);
        return true;
    }

    public WebStudioViewMode[] getViewSubModes(String modeType) {
        WebStudioViewMode[] modes = null;
        if ("developer".equals(modeType)) {
            modes = this.developerModes;
        } else if ("business".equals(modeType)) {
            modes = this.businessModes;
        }
        return modes;
    }

    public void addBenchmark(BenchmarkInfo bi) {
        this.benchmarks.add(0, bi);
    }

    public void addEventListener(StudioListener listener) {
        this.listeners.add(listener);
    }

    public void executeOperation(String operation, HttpSession session) {
        RepositoryTreeState treeState;
        UserWorkspaceProject project;
        if ("checkIn".equals(operation)) {
            try {
                project = this.getCurrentProject(session);
                if (project == null) {
                    return;
                }
                project.checkIn();
                treeState = (RepositoryTreeState)FacesUtils.getSessionParam((String)"repositoryTreeState");
                treeState.invalidateTree();
            }
            catch (Exception e) {
                LOG.error((Object)"Can not check in!", (Throwable)e);
            }
        }
        if ("checkOut".equals(operation)) {
            try {
                project = this.getCurrentProject(session);
                if (project == null) {
                    return;
                }
                project.checkOut();
                treeState = (RepositoryTreeState)FacesUtils.getSessionParam((String)"repositoryTreeState");
                treeState.invalidateTree();
                this.reset(ReloadType.FORCED);
            }
            catch (Exception e) {
                LOG.error((Object)"Can not check out!", (Throwable)e);
            }
        }
    }

    private int findMode(WebStudioViewMode[] modes, int modeIdx, boolean sameType) {
        if (sameType) {
            modeIdx = (modeIdx + 1) % modes.length;
        }
        this.mode = modes[modeIdx];
        return modeIdx;
    }

    public BenchmarkInfo[] getBenchmarks() {
        return this.benchmarks.toArray(new BenchmarkInfo[0]);
    }

    public UserWorkspaceProject getCurrentProject(HttpSession session) {
        if (this.currentModule != null) {
            try {
                String projectFolder = this.currentModule.getProject().getProjectFolder().getName();
                RulesUserSession rulesUserSession = WebStudioUtils.getRulesUserSession(session);
                UserWorkspaceProject project = (UserWorkspaceProject)rulesUserSession.getUserWorkspace().getProject(projectFolder);
                return project;
            }
            catch (Exception e) {
                LOG.error((Object)"Error when trying to get current project", (Throwable)e);
            }
        }
        return null;
    }

    public UserWorkspaceProject getCurrentProject() {
        return this.getCurrentProject(FacesUtils.getSession());
    }

    public Module getCurrentModule() {
        return this.currentModule;
    }

    public RulesProjectResolver getProjectResolver() {
        return this.projectResolver;
    }

    public WebStudioViewMode getMode() {
        return this.mode;
    }

    public ProjectModel getModel() {
        return this.model;
    }

    public WebStudioProperties getProperties() {
        return this.properties;
    }

    public String getTableUri() {
        return this.tableUri;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public synchronized void invalidateProjects() {
        this.projects = null;
    }

    public synchronized List<ProjectDescriptor> getAllProjects() {
        if (this.projects == null) {
            this.projects = this.projectResolver.listOpenLProjects();
        }
        return this.projects;
    }

    public void removeBenchmark(int i) {
        this.benchmarks.remove(i);
    }

    public boolean removeListener(StudioListener listener) {
        return this.listeners.remove(listener);
    }

    public void reset(ReloadType reloadType) {
        try {
            if (reloadType == ReloadType.FORCED) {
                this.invalidateProjects();
            }
            this.model.reset(reloadType);
            for (StudioListener listener : this.listeners) {
                listener.studioReset();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to reset studio model", (Throwable)e);
        }
    }

    public void rebuildModel() {
        this.reset(ReloadType.SINGLE);
        this.model.buildProjectTree();
    }

    public void selectModule(String moduleId) throws Exception {
        if (moduleId == null) {
            if (this.currentModule != null) {
                return;
            }
            if (this.getAllProjects().size() > 0) {
                this.setCurrentModule((Module)this.getAllProjects().get(0).getModules().get(0));
            }
            return;
        }
        for (ProjectDescriptor project : this.getAllProjects()) {
            for (Module module : project.getModules()) {
                String curModuleId = this.getModuleId(module);
                if (!curModuleId.equals(moduleId)) continue;
                this.setCurrentModule(module);
                return;
            }
        }
        if (this.getAllProjects().size() > 0) {
            this.setCurrentModule((Module)this.getAllProjects().get(0).getModules().get(0));
        }
    }

    public void setCurrentModule(Module module) throws Exception {
        if (this.currentModule != module) {
            this.model.setModuleInfo(module);
        }
        this.currentModule = module;
        for (StudioListener listener : this.listeners) {
            listener.studioReset();
        }
    }

    public void switchMode(String type) throws Exception {
        boolean sameType = type.equals(this.mode.getType());
        if ("business".equals(type)) {
            this.businessModeIdx = this.findMode(this.businessModes, this.businessModeIdx, sameType);
        } else if ("developer".equals(type)) {
            this.developerModeIdx = this.findMode(this.developerModes, this.developerModeIdx, sameType);
        } else {
            throw new RuntimeException("Invalid Mode: " + type);
        }
        this.model.redraw();
    }

    public void setMode(WebStudioViewMode mode) throws Exception {
        this.mode = mode;
        this.model.redraw();
    }

    public void setMode(String name) throws Exception {
        WebStudioViewMode mode = this.getViewMode(name);
        this.setMode(mode);
    }

    public WebStudioViewMode getViewMode(String name) {
        for (WebStudioViewMode mode : this.businessModes) {
            if (!name.equals(mode.getName())) continue;
            return mode;
        }
        for (WebStudioViewMode mode : this.developerModes) {
            if (!name.equals(mode.getName())) continue;
            return mode;
        }
        return null;
    }

    public void setProperties(WebStudioProperties properties) {
        this.properties = properties;
    }

    public void setTableUri(String tableUri) {
        this.tableUri = tableUri;
    }

    public boolean isShowFormulas() {
        return this.showFormulas;
    }

    public void setShowFormulas(String showFormulas) {
        this.showFormulas = Boolean.parseBoolean(showFormulas);
    }

    public boolean isCollapseProperties() {
        return this.collapseProperties;
    }

    public void setCollapseProperties(String collapseProperties) {
        this.collapseProperties = Boolean.parseBoolean(collapseProperties);
    }

    public String getModuleId(Module module) {
        if (module != null) {
            return module.getProject().getId() + " - " + module.getName();
        }
        return null;
    }

    public TraceHelper getTraceHelper() {
        TraceHelper traceHelper = (TraceHelper)FacesUtils.getSessionParam((String)TRACER_NAME);
        if (traceHelper == null) {
            traceHelper = new TraceHelper();
            Map sessionMap = FacesUtils.getSessionMap();
            sessionMap.put(TRACER_NAME, traceHelper);
        }
        return traceHelper;
    }

    static interface StudioListener
    extends EventListener {
        public void studioReset();
    }
}

