/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import java.io.File;
import org.openl.rules.project.instantiation.ReloadType;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.ResolvingStrategy;
import org.openl.rules.project.resolving.RulesProjectResolver;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.ui.WebStudio;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.IBenchmarkableMethod;
import org.openl.util.benchmark.BenchmarkUnit;
import org.openl.util.benchmark.Profiler;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.SimpleVM;

public class WebStudioProfiler
extends Profiler.Unit {
    String[] args;

    public static void main(String[] args) throws Exception {
        new WebStudioProfiler().run(args);
    }

    public BenchmarkUnit makeBenchMarkUnit() throws Exception {
        String project = this.args[0];
        String wrapperClass = this.args[1];
        String methodName = this.args[2];
        File projectFolder = new File(project);
        WebStudio studio = new WebStudio();
        String workspace = studio.getWorkspacePath();
        RulesProjectResolver projectResolver = RulesProjectResolver.loadProjectResolverFromClassPath();
        projectResolver.setWorkspace(workspace);
        ResolvingStrategy strategy = projectResolver.isRulesProject(projectFolder);
        ProjectDescriptor projectDescriptor = strategy.resolveProject(projectFolder);
        Module module = projectDescriptor.getModuleByClassName(wrapperClass);
        ProjectModel model = new ProjectModel(studio);
        model.setModuleInfo(module, ReloadType.NO);
        IRuntimeEnv env = new SimpleVM().getRuntimeEnv();
        Object instance = model.getCompiledOpenClass().getOpenClassWithErrors().newInstance(env);
        IOpenMethod m = model.getCompiledOpenClass().getOpenClass().getMethod(methodName, null);
        if (m == null) {
            throw new Exception("Method " + methodName + " not found");
        }
        if (m instanceof IBenchmarkableMethod) {
            IBenchmarkableMethod bm = (IBenchmarkableMethod)m;
            return new BMMethodBenchmarkUnit(bm, instance, env);
        }
        return new MethodBenchmarkUnit(m, instance, env);
    }

    private void run(String[] arg) throws Exception {
        this.args = arg;
        int N = 10;
        if (this.args.length > 3) {
            N = Integer.parseInt(this.args[3]);
        }
        new Profiler(N).profileUnit((Profiler.Unit)this);
    }

    static class MethodBenchmarkUnit
    extends BenchmarkUnit {
        IOpenMethod m;
        Object instance;
        IRuntimeEnv env;
        Object[] params = new Object[0];

        public MethodBenchmarkUnit(IOpenMethod m, Object instance, IRuntimeEnv env) {
            this.m = m;
            this.instance = instance;
            this.env = env;
        }

        protected void run() throws Exception {
            this.m.invoke(this.instance, this.params, this.env);
        }
    }

    static class BMMethodBenchmarkUnit
    extends MethodBenchmarkUnit {
        public BMMethodBenchmarkUnit(IBenchmarkableMethod bm, Object instance, IRuntimeEnv env) {
            super((IOpenMethod)bm, instance, env);
        }

        public void runNtimes(int times) throws Exception {
            ((IBenchmarkableMethod)this.m).invokeBenchmark(this.instance, this.params, this.env, times);
        }
    }
}

