/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.copy;

import java.util.HashMap;
import java.util.Map;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.tableeditor.renderkit.TableProperty;
import org.openl.rules.ui.copy.TablePropertyCopier;
import org.openl.util.conf.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewVersionTableCopier
extends TablePropertyCopier {
    private static final String VERSION_PROP_NAME = "version";
    private static final String ACTIVE_PROP_NAME = "active";

    public NewVersionTableCopier(String tableUri) {
        super(tableUri, true);
        this.checkVersionPropertyExistance();
    }

    private void checkVersionPropertyExistance() {
        TableProperty versionProperty = super.getVersion();
        if (versionProperty == null) {
            versionProperty = new TableProperty.TablePropertyBuilder(VERSION_PROP_NAME, TablePropertyDefinitionUtils.getPropertyTypeByPropertyName((String)VERSION_PROP_NAME)).displayName(TablePropertyDefinitionUtils.getPropertyDisplayName((String)VERSION_PROP_NAME)).value((Object)"0.0.1").build();
            this.getPropertiesManager().addProperty(versionProperty);
        }
    }

    @Override
    protected void doCopy() throws CreateTableException {
        super.doCopy();
        this.updateOriginalTable();
    }

    private void updateOriginalTable() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(ACTIVE_PROP_NAME, "false");
        Version version = this.getOriginalVersion();
        if (version == null) {
            properties.put(VERSION_PROP_NAME, "0.0.1");
        }
        this.updatePropertiesForOriginalTable(properties);
    }

    @Override
    protected Map<String, Object> buildProperties() {
        Map<String, Object> properties = super.buildProperties();
        properties.put(ACTIVE_PROP_NAME, true);
        return properties;
    }

    @Override
    public String getName() {
        return "changeVersion";
    }

    public Version getOriginalVersion() {
        TableSyntaxNode originalNode = this.getCopyingTable();
        if (originalNode != null) {
            ITableProperties tableProperties = originalNode.getTableProperties();
            String version = tableProperties.getVersion();
            try {
                return Version.parseVersion((String)version, (int)0, (String)"..");
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Version getMinNextVersion() {
        Version originalVersion = this.getOriginalVersion();
        if (originalVersion == null) {
            originalVersion = Version.parseVersion((String)"0.0.1", (int)0, (String)"..");
        }
        originalVersion.setVariant(originalVersion.getVariant() + 1);
        return originalVersion;
    }
}

