/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.copy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.TableBuilder;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.ui.tablewizard.WizardBase;
import org.openl.rules.webstudio.properties.SystemValuesManager;
import org.openl.rules.webstudio.web.util.WebStudioUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableCopier
extends WizardBase {
    private String elementUri = null;
    @NotEmpty(message="Technical name can not be empty")
    @Pattern(regexp="([a-zA-Z_][a-zA-Z_0-9]*)?", message="Invalid technical name")
    private String tableTechnicalName;
    private String tableBusinessName;
    private boolean edit = false;

    protected void doCopy() throws CreateTableException {
        WebStudio studio = WebStudioUtils.getWebStudio();
        ProjectModel model = studio.getModel();
        XlsSheetSourceCodeModule sheetSourceModule = this.getDestinationSheet();
        String newTableUri = this.buildTable(sheetSourceModule, model);
        this.setNewTableUri(newTableUri);
        this.getModifiedWorkbooks().add(sheetSourceModule.getWorkbookSource());
    }

    protected String buildTable(XlsSheetSourceCodeModule sourceCodeModule, ProjectModel model) throws CreateTableException {
        IGridTable originalTable = model.getGridTable(this.elementUri);
        TableSyntaxNode baseNode = model.getNode(this.elementUri);
        String baseTableType = baseNode.getType();
        XlsSheetGridModel gridModel = new XlsSheetGridModel(sourceCodeModule);
        TableBuilder builder = new TableBuilder(gridModel);
        int logicBaseTableStartRow = 0;
        boolean envTable = XlsNodeTypes.XLS_ENVIRONMENT.toString().equals(baseTableType);
        boolean otherTable = XlsNodeTypes.XLS_OTHER.toString().equals(baseTableType);
        String newHeader = null;
        ICellStyle headerStyle = null;
        Map<String, Object> buildedPropForNewTable = null;
        ICellStyle propertiesStyle = null;
        if (!envTable && !otherTable) {
            newHeader = this.buildHeader(baseNode.getHeaderLineValue().getValue(), baseTableType);
            headerStyle = originalTable.getCell(0, 0).getStyle();
            ++logicBaseTableStartRow;
            ITableProperties tableProperties = baseNode.getTableProperties();
            Map baseTablePhysicalProperties = null;
            if (tableProperties != null) {
                propertiesStyle = this.getPropertiesStyle(tableProperties);
                baseTablePhysicalProperties = tableProperties.getPropertiesDefinedInTable();
            }
            buildedPropForNewTable = this.buildProperties();
            logicBaseTableStartRow += baseTablePhysicalProperties == null ? 0 : baseTablePhysicalProperties.size();
        }
        IGridTable gridTable = (IGridTable)originalTable.getSubtable(0, logicBaseTableStartRow, originalTable.getWidth(), originalTable.getHeight() - logicBaseTableStartRow);
        int tableWidth = originalTable.getWidth();
        if (tableWidth < 3 && buildedPropForNewTable != null && !buildedPropForNewTable.isEmpty()) {
            tableWidth = 3;
        }
        int tableHeight = 0;
        if (newHeader != null) {
            ++tableHeight;
        }
        if (buildedPropForNewTable != null) {
            tableHeight += buildedPropForNewTable.size();
        }
        builder.beginTable(tableWidth, tableHeight += gridTable.getHeight());
        if (newHeader != null) {
            builder.writeHeader(newHeader, headerStyle);
        }
        if (buildedPropForNewTable != null && !buildedPropForNewTable.isEmpty()) {
            builder.writeProperties(buildedPropForNewTable, propertiesStyle);
        }
        builder.writeGridTable(gridTable);
        String uri = gridModel.getRangeUri(builder.getTableRegion());
        builder.endTable();
        return uri;
    }

    protected abstract Map<String, Object> buildProperties();

    protected Map<String, Object> buildSystemProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List systemPropDefinitions = TablePropertyDefinitionUtils.getSystemProperties();
        for (TablePropertyDefinition systemPropDef : systemPropDefinitions) {
            Object systemValue;
            if (!systemPropDef.getSystemValuePolicy().equals((Object)TablePropertyDefinition.SystemValuePolicy.IF_BLANK_ONLY) || (systemValue = SystemValuesManager.getInstance().getSystemValue(systemPropDef.getSystemValueDescriptor())) == null) continue;
            result.put(systemPropDef.getName(), systemValue);
        }
        return result;
    }

    protected String buildHeader(String header, String tableType) {
        String tableOldTechnicalName = this.parseTechnicalName(header, tableType);
        String repl = "\\b" + tableOldTechnicalName + "(?=\\s*(\\(.*\\))?$)";
        return header.trim().replaceFirst(repl, this.tableTechnicalName.trim());
    }

    protected void initTableNames() {
        TableSyntaxNode node = this.getCopyingTable();
        if (node != null) {
            this.tableTechnicalName = this.parseTechnicalName(node.getHeaderLineValue().getValue(), node.getType());
            ITableProperties tableProperties = node.getTableProperties();
            if (tableProperties != null) {
                this.tableBusinessName = node.getTableProperties().getName();
            }
        }
    }

    protected TableSyntaxNode getCopyingTable() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        studio.setTableUri(this.elementUri);
        ProjectModel model = studio.getModel();
        return model.getNode(this.elementUri);
    }

    protected String parseTechnicalName(String header, String tableType) {
        String result = null;
        String headerIntern = header;
        String[] headerTokens = null;
        if (!XlsNodeTypes.XLS_ENVIRONMENT.toString().equals(tableType) && !XlsNodeTypes.XLS_OTHER.toString().equals(tableType)) {
            headerIntern = header.replaceFirst("\\(.*\\)", "");
            headerTokens = StringUtils.split((String)headerIntern);
            result = headerTokens[headerTokens.length - 1];
        }
        return result;
    }

    @Override
    protected void reset() {
        super.reset();
        this.elementUri = null;
        this.tableTechnicalName = null;
        this.tableBusinessName = null;
    }

    protected String getElementUri() {
        return this.elementUri;
    }

    protected void setElementUri(String elementUri) {
        this.elementUri = elementUri;
    }

    public boolean isEdit() {
        return this.edit;
    }

    protected void setEdit(boolean edit) {
        this.edit = edit;
    }

    protected void initUri() {
        this.elementUri = FacesUtils.getRequestParameter((String)"uri");
        WebStudio studio = WebStudioUtils.getWebStudio();
        if (StringUtils.isNotBlank((String)this.elementUri)) {
            this.initTableNames();
        } else {
            this.elementUri = studio.getTableUri();
        }
    }

    @Override
    protected void onCancel() {
        this.reset();
    }

    @Override
    protected void onStart() {
        this.reset();
        this.initWorkbooks();
    }

    protected ICellStyle getPropertiesStyle(ITableProperties tableProperties) {
        ICellStyle propertiesStyle = null;
        ILogicalTable propertiesSection = tableProperties.getPropertiesSection();
        if (propertiesSection != null) {
            propertiesStyle = propertiesSection.getSource().getCell(0, 0).getStyle();
        }
        return propertiesStyle;
    }

    public String getTableBusinessName() {
        return this.tableBusinessName;
    }

    public String getTableTechnicalName() {
        return this.tableTechnicalName;
    }

    public void setTableBusinessName(String tableBusinessName) {
        this.tableBusinessName = tableBusinessName;
    }

    public void setTableTechnicalName(String tableTechnicalName) {
        this.tableTechnicalName = tableTechnicalName;
    }

    @Override
    protected void onFinish() throws Exception {
        this.doCopy();
        super.onFinish();
    }

    @Override
    protected String makeUrlForNewTable() {
        return super.makeUrlForNewTable() + "&mode=" + (this.edit ? "edit" : "view");
    }
}

