/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.copy;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ajax4jsf.component.UIRepeat;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.constraints.Constraint;
import org.openl.rules.table.constraints.Constraints;
import org.openl.rules.table.constraints.LessThanConstraint;
import org.openl.rules.table.constraints.MoreThanConstraint;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.DefaultPropertyDefinitions;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.rules.tableeditor.model.TableEditorModel;
import org.openl.rules.tableeditor.renderkit.TableProperty;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.ui.copy.TableCopier;
import org.openl.rules.ui.tablewizard.PropertiesBean;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.util.conf.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePropertyCopier
extends TableCopier {
    private static final Log LOG = LogFactory.getLog(TablePropertyCopier.class);
    private PropertiesBean propertiesManager;
    public static final String INIT_VERSION = "0.0.1";
    private UIRepeat propsTable;

    public PropertiesBean getPropertiesManager() {
        return this.propertiesManager;
    }

    public TablePropertyCopier(String elementUri) {
        this(elementUri, false);
    }

    public TablePropertyCopier(String elementUri, boolean edit) {
        this.start();
        this.setElementUri(elementUri);
        this.propertiesManager = new PropertiesBean(this.getAllPossibleProperties(this.getCopyingTable().getType()));
        this.initTableNames();
        this.initProperties();
        this.setEdit(edit);
    }

    private List<String> getAllPossibleProperties(String tableType) {
        TablePropertyDefinition[] propDefinitions;
        ArrayList<String> possibleProperties = new ArrayList<String>();
        for (TablePropertyDefinition propDefinition : propDefinitions = DefaultPropertyDefinitions.getDefaultDefinitions()) {
            String propertyName;
            if (propDefinition.isSystem() || !PropertiesChecker.isPropertySuitableForTableType((String)(propertyName = propDefinition.getName()), (String)tableType) || !PropertiesChecker.isPropertySuitableForLevel((InheritanceLevel)InheritanceLevel.TABLE, (String)propertyName)) continue;
            possibleProperties.add(propDefinition.getName());
        }
        return possibleProperties;
    }

    private void initProperties() {
        ArrayList<TableProperty> definedProperties = new ArrayList<TableProperty>();
        TablePropertyDefinition[] propDefinitions = DefaultPropertyDefinitions.getDefaultDefinitions();
        TableSyntaxNode node = this.getCopyingTable();
        for (TablePropertyDefinition propDefinition : propDefinitions) {
            String name;
            Object propertyValue;
            if (propDefinition.isSystem()) continue;
            ITableProperties tableProperties = node.getTableProperties();
            Object object = propertyValue = tableProperties.getPropertyValue(name = propDefinition.getName()) != null ? tableProperties.getPropertyValue(name) : null;
            if (!tableProperties.getPropertiesDefinedInTable().containsKey(name)) continue;
            Class propertyType = null;
            if (propDefinition.getType() != null) {
                propertyType = propDefinition.getType().getInstanceClass();
            }
            String displayName = propDefinition.getDisplayName();
            String format = propDefinition.getFormat();
            TableProperty tableProperty = new TableProperty.TablePropertyBuilder(name, propertyType).value(propertyValue).displayName(displayName).format(format).build();
            definedProperties.add(tableProperty);
        }
        this.propertiesManager.setProperties(definedProperties);
    }

    public String getValidationJS() {
        StringBuilder validation = new StringBuilder();
        TableProperty prop = this.getCurrentProp();
        Constraints constraints = prop.getConstraints();
        if (constraints != null) {
            String inputId = this.getInputIdJS(prop.getName());
            for (Constraint constraint : constraints.getAll()) {
                if (!(constraint instanceof LessThanConstraint) && !(constraint instanceof MoreThanConstraint)) continue;
                String validator = constraint instanceof LessThanConstraint ? "lessThan" : "moreThan";
                String compareToField = (String)constraint.getParams()[0];
                String compareToFieldId = this.getInputIdJS(compareToField);
                TableProperty compareToProperty = this.getProperty(prop.getName());
                String compareToPropertyDisplayName = compareToProperty == null ? "" : compareToProperty.getDisplayName();
                validation.append("new Validation(" + inputId + ", '" + validator + "', '', {compareToFieldId:" + compareToFieldId + ",messageParams:'" + compareToPropertyDisplayName + "'})");
            }
        }
        return validation.toString();
    }

    private String getInputIdJS(String propName) {
        return "$('" + this.propsTable.getParent().getId() + "').down('input[type=hidden][name=id][value=" + propName + "]').up().down('input').id";
    }

    private TableProperty getCurrentProp() {
        return (TableProperty)this.propsTable.getRowData();
    }

    private TableProperty getProperty(String name) {
        for (TableProperty property : this.propertiesManager.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public String getName() {
        return "changeProperties";
    }

    @Override
    protected Map<String, Object> buildProperties() {
        LinkedHashMap<String, Object> newProperties = new LinkedHashMap<String, Object>();
        newProperties.putAll(this.buildSystemProperties());
        for (TableProperty property : this.propertiesManager.getProperties()) {
            String name = property.getName();
            Object value = property.getValue();
            if (value == null || value instanceof String && StringUtils.isEmpty((String)((String)value))) continue;
            newProperties.put(name.trim(), value);
        }
        return newProperties;
    }

    public void setPropsTable(UIRepeat propsTable) {
        this.propsTable = propsTable;
    }

    public UIRepeat getPropsTable() {
        return this.propsTable;
    }

    public TableProperty getVersion() {
        return this.getProperty("version");
    }

    public Version getMinNextVersion() {
        TableProperty originalVersion = this.getVersion();
        if (originalVersion != null && StringUtils.isNotEmpty((String)((String)originalVersion.getValue()))) {
            return Version.parseVersion((String)((String)originalVersion.getValue()), (int)0, (String)"..");
        }
        return Version.parseVersion((String)INIT_VERSION, (int)0, (String)"..");
    }

    protected void updatePropertiesForOriginalTable(Map<String, String> properties) {
        if (properties.size() > 0) {
            WebStudio studio = WebStudioUtils.getWebStudio();
            ProjectModel model = studio.getModel();
            TableEditorModel tableEditorModel = model.getTableEditorModel(this.getElementUri());
            Set<String> propNames = properties.keySet();
            try {
                for (String propName : propNames) {
                    String propValue = properties.get(propName);
                    tableEditorModel.setProperty(propName, propValue);
                }
                this.getModifiedWorkbooks().add(tableEditorModel.getSheetSource().getWorkbookSource());
            }
            catch (Exception e) {
                LOG.error((Object)"Can not update table properties for original table", (Throwable)e);
            }
        }
    }
}

