/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.search.IOpenLSearch;
import org.openl.rules.search.OpenLBussinessSearch;
import org.openl.rules.table.IOpenLTable;
import org.openl.rules.table.properties.def.DefaultPropertyDefinitions;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.tableeditor.renderkit.TableProperty;
import org.openl.rules.ui.EnumValuesUIHelper;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.ui.search.BussinessSearchResultBean;
import org.openl.rules.webstudio.web.util.WebStudioUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BussinesSearchPropertyBean {
    private List<TableProperty> propForSearch = new ArrayList<TableProperty>();
    private List<TableProperty> filledPropsForSearch = new ArrayList<TableProperty>();
    private String tableContain;
    private final OpenLBussinessSearch search = new OpenLBussinessSearch();
    private BussinessSearchResultBean busSearchResBean = null;
    private EnumValuesUIHelper enumHelper = new EnumValuesUIHelper();

    public BussinessSearchResultBean getBusSearchResBean() {
        return this.busSearchResBean;
    }

    public void setBusSearchResBean(BussinessSearchResultBean busSearchResBean) {
        this.busSearchResBean = busSearchResBean;
    }

    public String getTableContain() {
        return this.tableContain;
    }

    public void setTableContain(String tableContain) {
        this.tableContain = tableContain;
    }

    public List<TableProperty> getPropForSearch() {
        return this.propForSearch;
    }

    public void setPropForSearch(List<TableProperty> propForSearch) {
        this.propForSearch = propForSearch;
    }

    public BussinesSearchPropertyBean() {
        TablePropertyDefinition[] propDefinitions;
        for (TablePropertyDefinition propDefinition : propDefinitions = DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.isBusinessSearch()) continue;
            Class propertyType = propDefinition.getType() == null ? null : propDefinition.getType().getInstanceClass();
            this.propForSearch.add(new TableProperty.TablePropertyBuilder(propDefinition.getName(), propertyType).displayName(propDefinition.getDisplayName()).group(propDefinition.getGroup()).format(propDefinition.getFormat()).constraints(propDefinition.getConstraints()).build());
        }
    }

    public boolean isProjectEditable() {
        WebStudio webStudio = WebStudioUtils.getWebStudio();
        return webStudio != null && webStudio.getModel().isEditable();
    }

    public void initBusSearchCond() {
        if (this.isAnyPropertyFilled()) {
            Map mapforSearch = this.search.getBusSearchCondit().getPropToSearch();
            mapforSearch.clear();
            for (TableProperty prop : this.filledPropsForSearch) {
                mapforSearch.put(prop.getName(), prop.getValue());
            }
            this.search.getBusSearchCondit().setTablesContains(this.searchTableContains());
        }
    }

    public boolean isReady() {
        return WebStudioUtils.isStudioReady();
    }

    public boolean isAnyPropertyFilled() {
        this.filledPropsForSearch.clear();
        boolean result = false;
        for (TableProperty prop : this.propForSearch) {
            if (prop.getValue() == null || !StringUtils.isNotEmpty((String)prop.getDisplayValue())) continue;
            this.filledPropsForSearch.add(prop);
            result = true;
        }
        return result;
    }

    public TableSyntaxNode[] searchTableContains() {
        String[][] values = new String[][]{};
        TableSyntaxNode[] result = null;
        ArrayList<TableSyntaxNode> resultNodes = new ArrayList<TableSyntaxNode>();
        if (this.tableContain != "") {
            values = WebStudioUtils.getWebStudio().getModel().getIndexer().getResultsForQuery(this.tableContain, 200, null);
            if (values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    String uri = values[i][0];
                    if (uri.indexOf(".xls") < 0) continue;
                    resultNodes.add(WebStudioUtils.getWebStudio().getModel().getNode(uri));
                }
            }
            result = resultNodes.toArray(new TableSyntaxNode[0]);
        }
        return result;
    }

    public EnumValuesUIHelper getEnumHelper() {
        return this.enumHelper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BussinessSearchRequest {
        private boolean needSearch;
        private BussinesSearchPropertyBean bussinessSearchBean;
        private List<IOpenLTable> tableSearchList;

        public BussinesSearchPropertyBean getBussinessSearchBean() {
            return this.bussinessSearchBean;
        }

        public void setBussinessSearchBean(BussinesSearchPropertyBean bussinessSearchBean) {
            this.bussinessSearchBean = bussinessSearchBean;
        }

        public boolean isSearching() {
            return this.needSearch;
        }

        public String search() {
            this.needSearch = true;
            this.bussinessSearchBean.initBusSearchCond();
            return null;
        }

        public List<IOpenLTable> getSearchResults() {
            if (!(this.isSearching() && this.bussinessSearchBean.isReady() && this.bussinessSearchBean.isAnyPropertyFilled())) {
                return Collections.emptyList();
            }
            if (this.tableSearchList == null) {
                ProjectModel model = WebStudioUtils.getWebStudio().getModel();
                model.runSearch((IOpenLSearch)this.bussinessSearchBean.search);
                this.tableSearchList = model.getBussinessSearchResults(model.runSearch((IOpenLSearch)this.bussinessSearchBean.search));
            }
            return this.tableSearchList;
        }
    }
}

