/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.search;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.openl.main.SourceCodeURLTool;
import org.openl.rules.indexer.DefaultIndexer;
import org.openl.rules.indexer.HitBucket;
import org.openl.rules.indexer.IIndexElement;
import org.openl.rules.indexer.IIndexParser;
import org.openl.rules.indexer.IIndexer;
import org.openl.rules.indexer.Index;
import org.openl.rules.indexer.IndexQuery;
import org.openl.rules.indexer.IndexQueryParser;
import org.openl.rules.indexer.IndexRunner;
import org.openl.rules.indexer.TableIndexParser;
import org.openl.rules.indexer.WordDocIndexParser;
import org.openl.rules.indexer.WorkbookIndexParser;
import org.openl.rules.indexer.WorksheetIndexParser;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.tableeditor.model.ui.util.HTMLHelper;
import org.openl.rules.ui.search.IStringFilter;
import org.openl.rules.word.WordDocSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.util.FileTypeHelper;
import org.openl.util.Log;

public class FileIndexer {
    private long[] updateTimes;
    private String[] files = null;
    private Index index;

    static String getFileName(String path) {
        String fileName = "";
        if (StringUtils.isNotBlank((String)path)) {
            int index = path.lastIndexOf(47);
            fileName = index > 0 ? path.substring(index + 1) : path;
        }
        return fileName;
    }

    public static void main(String[] args) {
        IIndexParser[] parsers = new IIndexParser[]{new WorkbookIndexParser(), new WorksheetIndexParser(), new TableIndexParser()};
        IIndexer[] indexers = new IIndexer[]{};
        IndexRunner ixr = new IndexRunner(parsers, indexers, (IIndexer)new DefaultIndexer());
        Index index = new Index();
        String file = "C:\\__exigen\\customer\\SRP\\ContractAttributes_5.5.14.xls";
        for (int i = 0; i < 10; ++i) {
            FileSourceCodeModule source = new FileSourceCodeModule(file, null);
            XlsWorkbookSourceCodeModule src = new XlsWorkbookSourceCodeModule((IOpenSourceCodeModule)source);
            ixr.index((IIndexElement)src, index);
        }
    }

    public static void main2(String[] args) {
        IIndexParser[] parsers = new IIndexParser[]{new WorkbookIndexParser(), new WorksheetIndexParser(), new TableIndexParser()};
        IIndexer[] indexers = new IIndexer[]{};
        IndexRunner ixr = new IndexRunner(parsers, indexers, (IIndexer)new DefaultIndexer());
        Index index = new Index();
        String file = "C:\\__exigen\\customer\\SRP\\ContractAttributes_5.5.14.xls";
        FileSourceCodeModule source = new FileSourceCodeModule(file, null);
        XlsWorkbookSourceCodeModule src = new XlsWorkbookSourceCodeModule((IOpenSourceCodeModule)source);
        ixr.index((IIndexElement)src, index);
        IndexQuery iq = IndexQueryParser.parse((String)"account id unique");
        TreeSet hitBuckets = iq.executeSearch(index);
        String[] tokens = FileIndexer.tokens(iq.getTokensInclude(), index);
        for (HitBucket hb : hitBuckets) {
            String text = hb.getElement().getIndexedText();
            String res = HTMLHelper.htmlStringWithSelections((String)text, (String[])tokens);
            System.out.println("\n++++++++++++++++++++++\n" + hb.getWeight());
            System.out.println(res);
        }
    }

    static long[] getLastModifTime(String[] xfiles) {
        long[] times = new long[xfiles.length];
        for (int i = 0; i < xfiles.length; ++i) {
            times[i] = new File(xfiles[i]).lastModified();
        }
        return times;
    }

    public static String showElementHeader(String uri) {
        Map map = SourceCodeURLTool.parseUrl((String)uri);
        String file = (String)map.get("file");
        String sheet = (String)map.get("sheet");
        return FileIndexer.getFileName(file) + (sheet == null ? "" : " : " + sheet);
    }

    static String[] tokens(String[][] src, Index idx) {
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < src.length; ++i) {
            for (int j = 0; j < src[i].length; ++j) {
                String tx = src[i][j];
                Index.TokenBucket tb = idx.findEqualsTokenBucket(tx);
                if (tb == null) {
                    v.add(tx);
                    continue;
                }
                Iterator iter = tb.getTokens().iterator();
                while (iter.hasNext()) {
                    v.add((String)iter.next());
                }
            }
        }
        String[] ret = v.toArray(new String[v.size()]);
        Arrays.sort(ret, Index.TokenBucket.TOKEN_COMPARATOR);
        return ret;
    }

    public Index.TokenBucket[] getBuckets(String charStr) {
        TreeMap tm = (TreeMap)this.getIndex().getFirstCharMap().get(charStr);
        Index.TokenBucket[] tokenBucket = new Index.TokenBucket[tm.size()];
        int i = 0;
        Iterator iter = tm.values().iterator();
        while (iter.hasNext()) {
            tokenBucket[i] = (Index.TokenBucket)iter.next();
            ++i;
        }
        return tokenBucket;
    }

    public synchronized Index getIndex() {
        if (this.index == null) {
            this.index = this.makeIndex();
        }
        return this.index;
    }

    public String[] getLetters() {
        Index idx = this.getIndex();
        Vector<String> result = new Vector<String>();
        for (String s : idx.getFirstCharMap().keySet()) {
            if (!Character.isLetter(s.charAt(0))) continue;
            result.add(s);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[][] getResultsForIndex(String searchQuery) {
        Index.TokenBucket tb = this.getIndex().findEqualsTokenBucket(searchQuery);
        Vector<String[]> v = new Vector<String[]>();
        String[] tokens = new String[tb.getTokens().size()];
        int i = 0;
        Iterator i$ = tb.getTokens().iterator();
        while (i$.hasNext()) {
            String element;
            tokens[i] = element = (String)i$.next();
            ++i;
        }
        i = 1;
        for (HitBucket hb : tb.getIndexElements().values()) {
            String[] s1 = new String[3];
            s1[0] = hb.getElement().getUri();
            s1[1] = HTMLHelper.htmlStringWithSelections((String)hb.getElement().getIndexedText(), (String[])tokens);
            v.add(s1);
            ++i;
        }
        return (String[][])v.toArray((T[])new String[v.size()][]);
    }

    public String[][] getResultsForQuery(String searchQuery, int maxRes, IStringFilter uriFilter) {
        IndexQuery indexQuery = IndexQueryParser.parse((String)searchQuery);
        TreeSet searchRes = indexQuery.executeSearch(this.getIndex());
        String[] tokens = FileIndexer.tokens(indexQuery.getTokensInclude(), this.index);
        int size = Math.min(maxRes, searchRes.size());
        Vector<String[]> result = new Vector<String[]>(size);
        int cnt = 0;
        for (HitBucket hb : searchRes) {
            String uri;
            if (cnt >= size) break;
            if (uriFilter != null && !uriFilter.matchString(hb.getElement().getUri())) continue;
            String[] res = new String[3];
            res[0] = uri = hb.getElement().getUri();
            res[1] = HTMLHelper.htmlStringWithSelections((String)hb.getElement().getIndexedText(), (String[])tokens);
            result.add(res);
            ++cnt;
        }
        return (String[][])result.toArray((T[])new String[0][]);
    }

    public boolean isFilesChanged(String[] xfiles, long[] times) {
        boolean result = false;
        if (this.files == null || this.updateTimes == null || this.files.length != xfiles.length) {
            result = true;
        } else {
            int i;
            for (i = 0; i < xfiles.length; ++i) {
                if (xfiles[i].equals(this.files[i])) continue;
                result = true;
            }
            for (i = 0; i < times.length; ++i) {
                if (times[i] == this.updateTimes[i]) continue;
                result = true;
            }
        }
        return result;
    }

    public Index makeIndex() {
        Index indexResult = new Index();
        if (this.files != null) {
            IIndexParser[] parsers = new IIndexParser[]{new WorkbookIndexParser(), new WorksheetIndexParser(), new TableIndexParser(), new WordDocIndexParser()};
            IIndexer[] indexers = new IIndexer[]{};
            IndexRunner indexRunner = new IndexRunner(parsers, indexers, (IIndexer)new DefaultIndexer());
            for (String file : this.files) {
                System.out.print("Indexing " + file + " ... ");
                long start = System.currentTimeMillis();
                FileSourceCodeModule source = new FileSourceCodeModule(file, null);
                XlsWorkbookSourceCodeModule srcToIndex = null;
                if (FileTypeHelper.isExcelFile((String)file)) {
                    srcToIndex = new XlsWorkbookSourceCodeModule((IOpenSourceCodeModule)source);
                } else {
                    try {
                        srcToIndex = new WordDocSourceCodeModule((IOpenSourceCodeModule)source);
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                        Log.error((Object)"This is sometimes happenning with MS Word files using Apache POI. Hopefully either they fix it or we switch to another API", (Throwable)t);
                        Log.warn((Object)("Skipping " + file));
                        continue;
                    }
                }
                indexRunner.index((IIndexElement)srcToIndex, indexResult);
                long time = System.currentTimeMillis() - start;
                System.out.println(" Elapsed Time: " + time + "ms");
            }
        }
        return indexResult;
    }

    public void reset() {
        this.index = null;
    }

    public synchronized void setFiles(String[] xfiles) {
        long[] times = FileIndexer.getLastModifTime(xfiles);
        if (this.isFilesChanged(xfiles, times)) {
            this.index = null;
            this.files = xfiles;
            this.updateTimes = times;
        }
    }
}

