/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.search;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.search.GroupOperator;
import org.openl.rules.search.IOpenLSearch;
import org.openl.rules.search.ISearchConstants;
import org.openl.rules.search.OpenLAdvancedSearch;
import org.openl.rules.search.OpenLSavedSearch;
import org.openl.rules.search.SearchConditionElement;
import org.openl.rules.table.IOpenLTable;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.util.AStringBoolOperator;

public class OpenLAdvancedSearchBean {
    private static final Log LOG = LogFactory.getLog(OpenLAdvancedSearchBean.class);
    private static final SelectItem[] tableTypes = FacesUtils.createSelectItems((String[])OpenLAdvancedSearch.existingTableTypes);
    private static final SelectItem[] columnTypeValues = FacesUtils.createSelectItems((String[])ISearchConstants.colTypeValues);
    private static final SelectItem[] groupOperationValues = FacesUtils.createSelectItems((String[])GroupOperator.names);
    private static final SelectItem[] notFlagValues = FacesUtils.createSelectItems((String[])OpenLAdvancedSearch.nfValues);
    private static final SelectItem[] typeValues = FacesUtils.createSelectItems((String[])ISearchConstants.typeValues);
    private static final SelectItem[] opTypeValues = FacesUtils.createSelectItems((String[])AStringBoolOperator.getAllOperatorNames());
    private static final Map<String, Integer> tableType2Index = new HashMap<String, Integer>();
    private String[] selectedTableTypes;
    private String newSearchName;
    private SearchElementBean[] tableElements;
    private SearchElementBean[] columnElements;
    private final OpenLAdvancedSearch search = new OpenLAdvancedSearch();

    public OpenLAdvancedSearchBean() {
        this.updateTableElements();
        this.updateColumnElements();
    }

    public synchronized String addColCondition() {
        this.search.editAction("colAdd" + FacesUtils.getRequestParameter((String)"index"));
        this.updateColumnElements();
        return null;
    }

    public synchronized String addCondition() {
        this.search.editAction("add" + FacesUtils.getRequestParameter((String)"index"));
        this.updateTableElements();
        return null;
    }

    public String applySearch() {
        WebStudio webStudio = WebStudioUtils.getWebStudio();
        if (webStudio != null) {
            int index = -1;
            try {
                index = Integer.parseInt(FacesUtils.getRequestParameter((String)"index"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            OpenLSavedSearch[] savedSearches = webStudio.getModel().getSavedSearches();
            if (savedSearches != null && index >= 0 && index < savedSearches.length) {
                this.applySearch(savedSearches[index]);
            }
        }
        return null;
    }

    private void applySearch(OpenLSavedSearch savedSearch) {
        this.search.setTableElements(savedSearch.getTableElements());
        this.search.setColumnElements(savedSearch.getColumnElements());
        this.updateColumnElements();
        this.updateTableElements();
        String types = savedSearch.getTableTypes();
        this.setSelectedTableTypes(types.trim().split(", *"));
    }

    public synchronized String deleteColCondition() {
        this.search.editAction("colDelete" + FacesUtils.getRequestParameter((String)"index"));
        this.updateColumnElements();
        return null;
    }

    public synchronized String deleteCondition() {
        this.search.editAction("delete" + FacesUtils.getRequestParameter((String)"index"));
        this.updateTableElements();
        return null;
    }

    public synchronized SearchElementBean[] getColumnElements() {
        return this.columnElements;
    }

    public SelectItem[] getColumnTypeValues() {
        return columnTypeValues;
    }

    public SelectItem[] getGroupOperationValues() {
        return groupOperationValues;
    }

    public String getNewSearchName() {
        return this.newSearchName;
    }

    public SelectItem[] getNotFlagValues() {
        return notFlagValues;
    }

    public SelectItem[] getOpTypeValues() {
        return opTypeValues;
    }

    public OpenLSavedSearch[] getSavedSearches() {
        WebStudio webStudio = WebStudioUtils.getWebStudio();
        if (webStudio != null) {
            return webStudio.getModel().getSavedSearches();
        }
        return null;
    }

    public String[] getSelectedTableTypes() {
        return this.selectedTableTypes;
    }

    public String getStudioView() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        return studio == null ? null : studio.getModel().getTableView(FacesUtils.getRequestParameter((String)"view"));
    }

    public synchronized SearchElementBean[] getTableElements() {
        return this.tableElements;
    }

    public SelectItem[] getTableTypes() {
        return tableTypes;
    }

    public SelectItem[] getTypeValues() {
        return typeValues;
    }

    public boolean isReady() {
        return WebStudioUtils.isStudioReady();
    }

    public boolean isShowSearches() {
        OpenLSavedSearch[] savedSearches = this.getSavedSearches();
        return savedSearches != null && savedSearches.length > 0;
    }

    public boolean isProjectEditable() {
        WebStudio webStudio = WebStudioUtils.getWebStudio();
        return webStudio != null && webStudio.getModel().isEditable();
    }

    public String save() {
        WebStudio webStudio = WebStudioUtils.getWebStudio();
        if (webStudio != null) {
            try {
                OpenLSavedSearch savedSearch = new OpenLSavedSearch(this.search.getColumnElements(), this.search.getTableElements(), this.selectedTableTypes);
                savedSearch.setName(this.getNewSearchName());
                webStudio.getModel().saveSearch(savedSearch);
            }
            catch (Exception e) {
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Failed to save search", e.getMessage()));
                LOG.error((Object)"failed to save search", (Throwable)e);
            }
        }
        return null;
    }

    public void setNewSearchName(String newSearchName) {
        this.newSearchName = newSearchName;
    }

    public void setSelectedTableTypes(String[] selectedTableTypes) {
        this.selectedTableTypes = selectedTableTypes;
        boolean[] selected = new boolean[tableTypes.length];
        for (String selectedTableType : selectedTableTypes) {
            Integer index = tableType2Index.get(selectedTableType);
            if (index == null) continue;
            selected[index.intValue()] = true;
        }
        for (int i = 0; i < selected.length; ++i) {
            this.search.selectTableType(i, selected[i]);
        }
    }

    private void updateColumnElements() {
        this.columnElements = new SearchElementBean[this.search.getColumnElements().length];
        for (int i = 0; i < this.columnElements.length; ++i) {
            this.columnElements[i] = new ColumnSearchElementBean(i);
        }
    }

    private void updateTableElements() {
        this.tableElements = new SearchElementBean[this.search.getTableElements().length];
        for (int i = 0; i < this.tableElements.length; ++i) {
            this.tableElements[i] = new SearchElementBean(i);
        }
    }

    static {
        for (int i = 0; i < OpenLAdvancedSearch.existingTableTypes.length; ++i) {
            tableType2Index.put(OpenLAdvancedSearch.existingTableTypes[i], i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchRequest {
        private boolean needSearch;
        private OpenLAdvancedSearchBean advancedSearchBean;
        private List<IOpenLTable> tableSearchList;

        public OpenLAdvancedSearchBean getAdvancedSearchBean() {
            return this.advancedSearchBean;
        }

        public List<IOpenLTable> getSearchResults() {
            if (!this.isSearching() || !this.advancedSearchBean.isReady()) {
                return Collections.emptyList();
            }
            if (this.tableSearchList == null) {
                ProjectModel model = WebStudioUtils.getWebStudio().getModel();
                this.tableSearchList = model.getAdvancedSearchResults(model.runSearch((IOpenLSearch)this.advancedSearchBean.search));
            }
            return this.tableSearchList;
        }

        public boolean isSearching() {
            return this.needSearch;
        }

        public String search() {
            this.needSearch = true;
            return null;
        }

        public void setAdvancedSearchBean(OpenLAdvancedSearchBean advancedSearchBean) {
            this.advancedSearchBean = advancedSearchBean;
        }
    }

    public class SearchElementBean {
        protected int index;

        SearchElementBean(int index) {
            this.index = index;
        }

        public String getGroupOperatorName() {
            return this.getSearchConditionElement().getGroupOperator().getName();
        }

        public String getNotFlag() {
            return OpenLAdvancedSearch.nfValues[this.getSearchConditionElement().isNotFlag() ? 1 : 0];
        }

        public GroupOperator getOperator() {
            return this.getSearchConditionElement().getGroupOperator();
        }

        public String getOpType1() {
            return this.getSearchConditionElement().getOpType1();
        }

        public String getOpType2() {
            return this.getSearchConditionElement().getOpType2();
        }

        protected SearchConditionElement getSearchConditionElement() {
            return OpenLAdvancedSearchBean.this.search.getTableElements()[this.index];
        }

        public String getType() {
            return this.getSearchConditionElement().getType();
        }

        public String getElementValueName() {
            return this.getSearchConditionElement().getElementValueName();
        }

        public String getElementValue() {
            return this.getSearchConditionElement().getElementValue();
        }

        public boolean isRequiredElementValueName() {
            return OpenLAdvancedSearchBean.this.search.showElementValueName(this.getType());
        }

        public void setGroupOperatorName(String groupOperatorName) {
            this.getSearchConditionElement().setGroupOperator(GroupOperator.find((String)groupOperatorName));
        }

        public void setNotFlag(String flag) {
            this.getSearchConditionElement().setNotFlag(OpenLAdvancedSearch.nfValues[1].equals(flag));
        }

        public void setOpType1(String type) {
            this.getSearchConditionElement().setOpType1(type);
        }

        public void setOpType2(String type) {
            this.getSearchConditionElement().setOpType2(type);
        }

        public void setType(String type) {
            this.getSearchConditionElement().setType(type);
        }

        public void setElementValueName(String elementValueName) {
            this.getSearchConditionElement().setElementValueName(elementValueName);
        }

        public void setElementValue(String elementValue) {
            this.getSearchConditionElement().setElementValue(elementValue);
        }
    }

    public class ColumnSearchElementBean
    extends SearchElementBean {
        public ColumnSearchElementBean(int index) {
            super(index);
        }

        protected SearchConditionElement getSearchConditionElement() {
            return OpenLAdvancedSearchBean.this.search.getColumnElements()[this.index];
        }
    }
}

