/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.faces.model.SelectItem;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.ui.tablewizard.WizardBase;
import org.openl.rules.ui.tablewizard.WizardUtils;
import org.openl.rules.webstudio.properties.SystemValuesManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BusinessTableCreationWizard
extends WizardBase {
    @Pattern(regexp="([a-zA-Z_][a-zA-Z_0-9\\- ]*)?", message="Invalid business name")
    private String businessName;
    private String categoryName;
    private String newCategoryName;
    private String categoryNameSelector = "existing";

    public String getBusinessName() {
        return this.businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.newCategoryName = null;
        this.categoryName = categoryName;
    }

    public String getCategoryNameSelector() {
        return this.categoryNameSelector;
    }

    public void setCategoryNameSelector(String categoryNameSelector) {
        this.categoryNameSelector = categoryNameSelector;
    }

    public String getNewCategoryName() {
        return this.newCategoryName;
    }

    public void setNewCategoryName(String newCategoryName) {
        this.categoryName = null;
        this.newCategoryName = newCategoryName;
    }

    public List<SelectItem> getCategoryNamesList() {
        ArrayList<SelectItem> categoryList = new ArrayList<SelectItem>();
        Set<String> categories = this.getAllCategories();
        for (String categoryName : categories) {
            categoryList.add(new SelectItem((Object)categoryName));
        }
        return categoryList;
    }

    private Set<String> getAllCategories() {
        TableSyntaxNode[] syntaxNodes;
        TreeSet<String> categories = new TreeSet<String>();
        for (TableSyntaxNode node : syntaxNodes = WizardUtils.getMetaInfo().getXlsModuleNode().getXlsTableSyntaxNodes()) {
            String categoryName;
            ITableProperties tableProperties = node.getTableProperties();
            if (tableProperties == null || !StringUtils.isNotBlank((String)(categoryName = tableProperties.getCategory()))) continue;
            categories.add(categoryName);
        }
        return categories;
    }

    protected String buildCategoryName() {
        String categoryName = StringUtils.isNotBlank((String)this.categoryName) ? this.categoryName : (StringUtils.isNotBlank((String)this.newCategoryName) ? this.newCategoryName : null);
        return categoryName;
    }

    protected Map<String, Object> buildSystemProperties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        List systemPropDefinitions = TablePropertyDefinitionUtils.getSystemProperties();
        for (TablePropertyDefinition systemPropDef : systemPropDefinitions) {
            Object systemValue;
            if (!systemPropDef.getSystemValuePolicy().equals((Object)TablePropertyDefinition.SystemValuePolicy.IF_BLANK_ONLY) || (systemValue = SystemValuesManager.getInstance().getSystemValue(systemPropDef.getSystemValueDescriptor())) == null) continue;
            result.put(systemPropDef.getName(), systemValue);
        }
        return result;
    }

    protected Map<String, Object> buildProperties() {
        String category;
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        if (StringUtils.isNotBlank((String)this.businessName)) {
            properties.put("name", this.businessName);
        }
        if ((category = this.buildCategoryName()) != null) {
            properties.put("category", category);
        }
        Map<String, Object> systemProperties = this.buildSystemProperties();
        properties.putAll(systemProperties);
        return properties;
    }
}

