/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import javax.faces.model.SelectItem;
import org.openl.rules.ui.tablewizard.ConditionClauseRegistry;
import org.openl.rules.ui.tablewizard.Parameter;
import org.openl.rules.ui.tablewizard.TableCondition;

public class ConditionClause {
    private final TableCondition tableCondition;
    private String paramName;
    private long variantId;
    private String conditionExpression;

    ConditionClause(TableCondition tableCondition) {
        this.tableCondition = tableCondition;
    }

    public String getConditionExpression() {
        return this.conditionExpression;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getType() {
        Parameter p = this.tableCondition.getParameterByName(this.paramName);
        return p == null ? null : p.getType();
    }

    public long getVariantId() {
        return this.variantId;
    }

    public SelectItem[] getVariantOptions() {
        SelectItem[] ret = null;
        String type = this.getType();
        if (type != null) {
            ret = ConditionClauseRegistry.getInstance().getItemsByType(type);
        }
        return ret == null ? new SelectItem[]{} : ret;
    }

    public void initParamName(String paramName) {
        this.paramName = paramName;
        SelectItem[] variants = this.getVariantOptions();
        if (variants.length > 0) {
            this.variantId = (Long)variants[0].getValue();
        }
    }

    public void setConditionExpression(String conditionExpression) {
        this.conditionExpression = conditionExpression;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void setVariantId(long variantId) {
        this.variantId = variantId;
    }
}

