/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.model.SelectItem;
import org.openl.rules.ui.tablewizard.ConditionClauseVariant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionClauseRegistry {
    private static ConditionClauseRegistry instance = new ConditionClauseRegistry();
    private static final Set<String> numericClasses = new HashSet<String>();
    private Map<String, List<ConditionClauseVariant>> registry;
    private Map<String, SelectItem[]> selectItems;
    private Map<Long, ConditionClauseVariant> id2Variant = new HashMap<Long, ConditionClauseVariant>();

    public static ConditionClauseRegistry getInstance() {
        return instance;
    }

    private static String getType(String clazz) {
        if (numericClasses.contains(clazz)) {
            return "numeric";
        }
        if (String.class.getName().equals(clazz)) {
            return "string";
        }
        if ("boolean".equals(clazz)) {
            return "boolean";
        }
        return "object";
    }

    public ConditionClauseRegistry() {
        this.registry = new HashMap<String, List<ConditionClauseVariant>>();
        ArrayList<ConditionClauseVariant> numericClauses = new ArrayList<ConditionClauseVariant>();
        numericClauses.add(new ConditionClauseVariant("less", "{0} < {1}"));
        numericClauses.add(new ConditionClauseVariant("more", "{0} > {1}"));
        numericClauses.add(new ConditionClauseVariant("equals", "{0} == {1}"));
        this.registry.put("numeric", numericClauses);
        ArrayList<ConditionClauseVariant> stringClauses = new ArrayList<ConditionClauseVariant>();
        stringClauses.add(new ConditionClauseVariant("starts", "{0}.startsWith({1})"));
        stringClauses.add(new ConditionClauseVariant("ends", "{0}.endsWith({1})"));
        stringClauses.add(new ConditionClauseVariant("equals", "{0}.equals({1})"));
        this.registry.put("string", stringClauses);
        ArrayList<ConditionClauseVariant> dateClauses = new ArrayList<ConditionClauseVariant>();
        dateClauses.add(new ConditionClauseVariant("equals", "{0}.equals({1})"));
        this.registry.put("object", dateClauses);
        ArrayList<ConditionClauseVariant> booleanClauses = new ArrayList<ConditionClauseVariant>();
        booleanClauses.add(new ConditionClauseVariant("equals", "{0} == {1})"));
        booleanClauses.add(new ConditionClauseVariant("not equal", "{0} != {1})"));
        this.registry.put("boolean", booleanClauses);
        this.index();
    }

    public ConditionClauseVariant get(long id) {
        return this.id2Variant.get(id);
    }

    public List<ConditionClauseVariant> getConditionClauseVariants(String clazz) {
        return this.registry.get(ConditionClauseRegistry.getType(clazz));
    }

    public SelectItem[] getItemsByType(String clazz) {
        return this.selectItems.get(ConditionClauseRegistry.getType(clazz));
    }

    private void index() {
        for (List<ConditionClauseVariant> list : this.registry.values()) {
            for (ConditionClauseVariant variant : list) {
                this.id2Variant.put(variant.getId(), variant);
            }
        }
        this.selectItems = new HashMap<String, SelectItem[]>();
        for (Map.Entry entry : this.registry.entrySet()) {
            SelectItem[] items = new SelectItem[((List)entry.getValue()).size()];
            int pos = 0;
            for (ConditionClauseVariant v : (List)entry.getValue()) {
                items[pos++] = new SelectItem((Object)v.getId(), v.getDisplayValue());
            }
            this.selectItems.put((String)entry.getKey(), items);
        }
    }

    static {
        numericClasses.add("int");
        numericClasses.add("byte");
        numericClasses.add("short");
        numericClasses.add("long");
        numericClasses.add("float");
        numericClasses.add("double");
        numericClasses.add("char");
    }
}

