/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.NotEmpty;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.domaintree.DomainTree;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.DatatypeAliasTableBuilder;
import org.openl.rules.ui.tablewizard.AliasValue;
import org.openl.rules.ui.tablewizard.BusinessTableCreationWizard;
import org.openl.rules.ui.tablewizard.WizardUtils;
import org.openl.types.IOpenClass;
import org.richfaces.component.html.HtmlDataTable;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeAliasTableCreationWizard
extends BusinessTableCreationWizard {
    @NotEmpty(message="Technical name can not be empty")
    @Pattern(regexp="([a-zA-Z_][a-zA-Z_0-9]*)?", message="Invalid table name")
    private String technicalName;
    private String aliasType;
    @Valid
    private List<AliasValue> values = new ArrayList<AliasValue>();
    private DomainTree domainTree;
    private SelectItem[] domainTypes;
    private HtmlDataTable valuesTable;

    public String getTechnicalName() {
        return this.technicalName;
    }

    public void setTechnicalName(String technicalName) {
        this.technicalName = technicalName;
    }

    public String getAliasType() {
        return this.aliasType;
    }

    public void setAliasType(String aliasType) {
        this.aliasType = aliasType;
    }

    public List<AliasValue> getValues() {
        return this.values;
    }

    public void setValues(List<AliasValue> values) {
        this.values = values;
    }

    public DomainTree getDomainTree() {
        return this.domainTree;
    }

    public SelectItem[] getDomainTypes() {
        return this.domainTypes;
    }

    public HtmlDataTable getValuesTable() {
        return this.valuesTable;
    }

    public void setValuesTable(HtmlDataTable valuesTable) {
        this.valuesTable = valuesTable;
    }

    @Override
    public String getName() {
        return "newDatatypeAliasTable";
    }

    @Override
    protected void onStart() {
        this.reset();
        this.domainTree = DomainTree.buildTree((IOpenClass)WizardUtils.getProjectOpenClass(), (boolean)false);
        Collection allClasses = this.domainTree.getAllClasses(true);
        this.domainTypes = FacesUtils.createSelectItems((Collection)allClasses);
        if (!CollectionUtils.isEmpty((Collection)allClasses) && CollectionUtils.contains(allClasses.iterator(), (Object)"String")) {
            this.setAliasType("String");
        }
        this.addValue();
    }

    @Override
    protected void onCancel() {
        this.reset();
    }

    protected String buildTable(XlsSheetSourceCodeModule sourceCodeModule) throws CreateTableException {
        XlsSheetGridModel gridModel = new XlsSheetGridModel(sourceCodeModule);
        DatatypeAliasTableBuilder builder = new DatatypeAliasTableBuilder(gridModel);
        Map<String, Object> properties = this.buildProperties();
        int width = 1;
        if (!properties.isEmpty()) {
            width = 3;
        }
        int height = 1 + properties.size() + this.values.size();
        builder.beginTable(width, height);
        builder.writeHeader(this.technicalName, this.aliasType);
        builder.writeProperties(properties, null);
        for (AliasValue value : this.values) {
            builder.writeValue(value.getValue());
        }
        String uri = gridModel.getRangeUri(builder.getTableRegion());
        builder.endTable();
        return uri;
    }

    @Override
    protected void onStepFirstVisit(int step) {
        switch (step) {
            case 4: {
                this.initWorkbooks();
            }
        }
    }

    public void addValue() {
        this.values.add(new AliasValue());
    }

    public void removeValue() {
        AliasValue value = (AliasValue)this.valuesTable.getRowData();
        this.values.remove(value);
    }

    @Override
    protected void reset() {
        this.technicalName = null;
        this.values = new ArrayList<AliasValue>();
        this.domainTree = null;
        this.domainTypes = null;
        super.reset();
    }

    @Override
    protected void onFinish() throws Exception {
        XlsSheetSourceCodeModule sheetSourceModule = this.getDestinationSheet();
        String newTableUri = this.buildTable(sheetSourceModule);
        this.setNewTableUri(newTableUri);
        this.getModifiedWorkbooks().add(sheetSourceModule.getWorkbookSource());
        super.onFinish();
    }
}

