/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.NotEmpty;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.domaintree.DomainTree;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.DatatypeTableBuilder;
import org.openl.rules.ui.tablewizard.BusinessTableCreationWizard;
import org.openl.rules.ui.tablewizard.TypeNamePair;
import org.openl.rules.ui.tablewizard.WizardUtils;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.richfaces.component.html.HtmlDataTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeTableCreationWizard
extends BusinessTableCreationWizard {
    @NotEmpty(message="Technical name can not be empty")
    @Pattern(regexp="([a-zA-Z_][a-zA-Z_0-9]*)?", message="Invalid table name")
    private String technicalName;
    @Valid
    private List<TypeNamePair> parameters = new ArrayList<TypeNamePair>();
    private DomainTree domainTree;
    private SelectItem[] definedDatatypes;
    private SelectItem[] domainTypes;
    private String parent;
    private HtmlDataTable parametersTable;

    public String getTechnicalName() {
        return this.technicalName;
    }

    public void setTechnicalName(String technicalName) {
        this.technicalName = technicalName;
    }

    public List<TypeNamePair> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<TypeNamePair> parameters) {
        this.parameters = parameters;
    }

    public DomainTree getDomainTree() {
        return this.domainTree;
    }

    public SelectItem[] getDefinedDatatypes() {
        return this.definedDatatypes;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public SelectItem[] getDomainTypes() {
        return this.domainTypes;
    }

    public HtmlDataTable getParametersTable() {
        return this.parametersTable;
    }

    public void setParametersTable(HtmlDataTable parametersTable) {
        this.parametersTable = parametersTable;
    }

    @Override
    public String getName() {
        return "newDatatypeTable";
    }

    @Override
    protected void onStart() {
        this.reset();
        this.domainTree = DomainTree.buildTree((IOpenClass)WizardUtils.getProjectOpenClass());
        ArrayList<String> datatypes = new ArrayList<String>(WizardUtils.getProjectOpenClass().getTypes().size());
        datatypes.add("");
        for (IOpenClass datatype : WizardUtils.getProjectOpenClass().getTypes().values()) {
            if (datatype instanceof DomainOpenClass) continue;
            datatypes.add(datatype.getName());
        }
        this.definedDatatypes = FacesUtils.createSelectItems(datatypes);
        this.domainTypes = FacesUtils.createSelectItems((Collection)this.domainTree.getAllClasses(true));
        this.addParameter();
    }

    @Override
    protected void onCancel() {
        this.reset();
    }

    protected String buildTable(XlsSheetSourceCodeModule sourceCodeModule) throws CreateTableException {
        XlsSheetGridModel gridModel = new XlsSheetGridModel(sourceCodeModule);
        DatatypeTableBuilder builder = new DatatypeTableBuilder(gridModel);
        Map<String, Object> properties = this.buildProperties();
        int width = 2;
        if (!properties.isEmpty()) {
            width = 3;
        }
        int height = 1 + properties.size() + this.parameters.size();
        builder.beginTable(width, height);
        builder.writeHeader(this.technicalName, this.parent);
        builder.writeProperties(properties, null);
        for (TypeNamePair parameter : this.parameters) {
            String paramType = parameter.getType();
            if (parameter.isIterable()) {
                paramType = paramType + "[]";
            }
            builder.writeParameter(paramType, parameter.getName());
        }
        String uri = gridModel.getRangeUri(builder.getTableRegion());
        builder.endTable();
        return uri;
    }

    @Override
    protected void onStepFirstVisit(int step) {
        switch (step) {
            case 4: {
                this.initWorkbooks();
            }
        }
    }

    public void addParameter() {
        this.parameters.add(new TypeNamePair());
    }

    public void removeParameter() {
        TypeNamePair parameter = (TypeNamePair)this.parametersTable.getRowData();
        this.parameters.remove(parameter);
    }

    @Override
    protected void reset() {
        this.technicalName = null;
        this.parameters = new ArrayList<TypeNamePair>();
        this.domainTree = null;
        this.domainTypes = null;
        super.reset();
    }

    @Override
    protected void onFinish() throws Exception {
        XlsSheetSourceCodeModule sheetSourceModule = this.getDestinationSheet();
        String newTableUri = this.buildTable(sheetSourceModule);
        this.setNewTableUri(newTableUri);
        this.getModifiedWorkbooks().add(sheetSourceModule.getWorkbookSource());
        super.onFinish();
    }
}

