/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.validation.constraints.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.validator.constraints.NotEmpty;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.domaintree.DomainTree;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.DecisionTableBuilder;
import org.openl.rules.ui.tablewizard.BusinessTableCreationWizard;
import org.openl.rules.ui.tablewizard.ConditionClause;
import org.openl.rules.ui.tablewizard.ListWithSelection;
import org.openl.rules.ui.tablewizard.Parameter;
import org.openl.rules.ui.tablewizard.TableArtifact;
import org.openl.rules.ui.tablewizard.TableCondition;
import org.openl.rules.ui.tablewizard.TypeNamePair;
import org.openl.rules.ui.tablewizard.WizardUtils;
import org.openl.types.IOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTableCreationWizard
extends BusinessTableCreationWizard {
    private static final Log LOG = LogFactory.getLog(DecisionTableCreationWizard.class);
    private static final String ORIENTATATION_HORIZONTAL = "hor";
    private static final String ORIENTATATION_VERTICAL = "ver";
    @NotEmpty(message="Technical name can not be empty")
    @Pattern(regexp="([a-zA-Z_][a-zA-Z_0-9]*)?", message="Invalid technical name")
    private String tableName;
    private String returnType;
    private boolean vertical;
    private List<TypeNamePair> parameters = new ArrayList<TypeNamePair>();
    private ListWithSelection<TableCondition> conditions = new ListWithSelection();
    private ListWithSelection<TableArtifact> actions = new ListWithSelection();
    private TableArtifact returnValue = new TableArtifact();
    private DomainTree domainTree;
    private SelectItem[] domainTypes;

    public void addAction() {
        if (this.validateAtStep4()) {
            this.actions.add(new TableArtifact());
            WizardUtils.autoRename(this.actions, "A");
            this.actions.selectLast();
        }
    }

    public void addActionParameter() {
        TableArtifact action = this.getCurrentAction();
        if (action != null) {
            action.getParameters().add(new Parameter());
        }
    }

    public void addCondition() {
        if (this.validateAtStep3()) {
            this.conditions.add(new TableCondition());
            WizardUtils.autoRename(this.conditions, "C");
            this.conditions.selectLast();
        }
    }

    public void addConditionClause() {
        TableCondition cond = this.getCurrentCondition();
        if (cond != null) {
            ConditionClause newClause = new ConditionClause(cond);
            cond.getLogicClauses().add(newClause);
            if (cond.getParamsCount() > 0) {
                newClause.initParamName(cond.getParameters().get(0).getName());
            }
        }
    }

    public void addConditionParameter() {
        TableCondition cond = this.getCurrentCondition();
        if (cond != null) {
            cond.getParameters().add(new Parameter());
        }
    }

    public void addParameter() {
        this.parameters.add(new TypeNamePair());
    }

    public void addReturnParameter() {
        this.getReturn().getParameters().add(new Parameter());
    }

    protected String buildTable(XlsSheetSourceCodeModule sourceCodeModule) throws CreateTableException {
        XlsSheetGridModel gridModel = new XlsSheetGridModel(sourceCodeModule);
        DecisionTableBuilder builder = new DecisionTableBuilder(gridModel);
        int tableWidth = this.returnValue.getParameters().size();
        for (TableCondition tableCondition : this.conditions) {
            tableWidth += tableCondition.getParameters().size();
        }
        for (TableArtifact tableArtifact : this.actions) {
            tableWidth += tableArtifact.getParameters().size();
        }
        int tableHeight = 8;
        builder.beginTable(tableWidth, tableHeight);
        StringBuilder stringBuilder = new StringBuilder(this.returnType).append(" ").append(this.tableName).append("(");
        boolean first = true;
        for (TypeNamePair typeNamePair : this.parameters) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(typeNamePair.getType()).append(" ").append(typeNamePair.getName());
        }
        stringBuilder.append(")");
        builder.writeHeader(stringBuilder.toString());
        builder.writeProperties(this.buildProperties(), null);
        this.doSaveWriteArtifacts(builder, this.conditions);
        this.doSaveWriteArtifacts(builder, this.actions);
        this.doSaveWriteArtifacts(builder, Collections.singletonList(this.returnValue));
        String newTableUri = gridModel.getRangeUri(builder.getTableRegion());
        builder.endTable();
        return newTableUri;
    }

    private void doSaveWriteArtifacts(DecisionTableBuilder builder, List<? extends TableArtifact> tableArtifacts) {
        for (TableArtifact tableArtifact : tableArtifacts) {
            List<Parameter> params = tableArtifact.getParameters();
            String[] names = new String[params.size()];
            String[] signatures = new String[params.size()];
            int index = 0;
            for (Parameter param : params) {
                names[index] = param.getBusinessName();
                signatures[index++] = param.getType() + " " + param.getName();
            }
            builder.writeElement(tableArtifact.getName(), tableArtifact.getLogic(), names, signatures);
        }
    }

    public int getActionCount() {
        return this.actions.size();
    }

    public List<TableArtifact> getActions() {
        return this.actions;
    }

    public int getConditionCount() {
        return this.conditions.size();
    }

    public List<TableCondition> getConditions() {
        return this.conditions;
    }

    public TableArtifact getCurrentAction() {
        return this.actions.getSelectedElement();
    }

    public TableCondition getCurrentCondition() {
        return this.conditions.getSelectedElement();
    }

    public DomainTree getDomainTree() {
        return this.domainTree;
    }

    public SelectItem[] getDomainTypes() {
        return this.domainTypes;
    }

    @Override
    public String getName() {
        return "newTable";
    }

    public String getOrientation() {
        return this.vertical ? ORIENTATATION_VERTICAL : ORIENTATATION_HORIZONTAL;
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public List<TypeNamePair> getParameters() {
        return this.parameters;
    }

    public TableArtifact getReturn() {
        return this.returnValue;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int getSelectedAction() {
        return this.actions.getSelectedIndex();
    }

    public int getSelectedCondition() {
        return this.conditions.getSelectedIndex();
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        switch (this.getStep()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int old = this.conditions.getSelectedIndex();
                int sz = this.conditions.size();
                boolean valid = true;
                try {
                    for (int i = 0; i < sz; ++i) {
                        this.conditions.setSelectedIndex(i);
                        valid = false;
                        if (this.validateAtStep3()) continue;
                        String string = null;
                        return string;
                    }
                    break;
                }
                finally {
                    if (valid) {
                        this.conditions.setSelectedIndex(old);
                    }
                }
            }
            case 4: {
                int old = this.actions.getSelectedIndex();
                int sz = this.actions.size();
                boolean valid = true;
                try {
                    for (int i = 0; i < sz; ++i) {
                        this.actions.setSelectedIndex(i);
                        valid = false;
                        if (this.validateAtStep4()) continue;
                        String string = null;
                        return string;
                    }
                    break;
                }
                finally {
                    if (valid) {
                        this.actions.setSelectedIndex(old);
                    }
                }
            }
            case 5: {
                if (this.validateAfterStep5()) break;
                return null;
            }
        }
        return super.next();
    }

    @Override
    protected void onCancel() {
        this.reset();
    }

    @Override
    protected void onStart() {
        this.reset();
        this.domainTree = DomainTree.buildTree((IOpenClass)WizardUtils.getProjectOpenClass());
        this.domainTypes = FacesUtils.createSelectItems((Collection)this.domainTree.getAllClasses(true));
    }

    @Override
    protected void onStepFirstVisit(int step) {
        switch (step) {
            case 1: {
                break;
            }
            case 2: {
                this.parameters.add(new TypeNamePair());
                break;
            }
            case 3: {
                this.addCondition();
                break;
            }
            case 4: {
                this.addAction();
                break;
            }
            case 5: {
                this.initWorkbooks();
            }
        }
    }

    public void removeAction() {
        if (this.removeByIndex(this.actions)) {
            WizardUtils.autoRename(this.actions, "A");
        }
    }

    public void removeActionParameter() {
        TableArtifact action = this.getCurrentAction();
        if (action != null && action.getParameters().size() > 1) {
            this.removeByIndex(action.getParameters());
        }
    }

    private boolean removeByIndex(List<?> list) {
        try {
            int index = Integer.parseInt(FacesUtils.getRequestParameter((String)"index"));
            if (0 <= index && index < list.size()) {
                list.remove(index);
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void removeCondition() {
        if (this.removeByIndex(this.conditions)) {
            WizardUtils.autoRename(this.conditions, "C");
        }
    }

    public void removeConditionClause() {
        TableCondition cond = this.getCurrentCondition();
        if (cond != null && cond.getLogicClauseCount() > 1) {
            this.removeByIndex(cond.getLogicClauses());
        }
    }

    public void removeConditionParameter() {
        TableCondition cond = this.getCurrentCondition();
        if (cond != null && cond.getParameters().size() > 1) {
            this.removeByIndex(cond.getParameters());
        }
    }

    public void removeParameter() {
        this.removeByIndex(this.parameters);
    }

    public void removeReturnParameter() {
        TableArtifact ret = this.getReturn();
        if (ret.getParameters().size() > 1) {
            this.removeByIndex(ret.getParameters());
        }
    }

    private void reportError(String clientId, String detail) {
        FacesContext.getCurrentInstance().addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Validation Error: ", detail));
    }

    @Override
    protected void reset() {
        this.returnType = null;
        this.tableName = null;
        this.parameters = new ArrayList<TypeNamePair>();
        this.conditions = new ListWithSelection();
        this.actions = new ListWithSelection();
        this.returnValue = new TableArtifact();
        this.returnValue.setName("RET1");
        this.vertical = false;
        this.domainTree = null;
        this.domainTypes = null;
        super.reset();
    }

    @Override
    protected void onFinish() throws Exception {
        XlsSheetSourceCodeModule sheetSourceModule = this.getDestinationSheet();
        String newTableUri = this.buildTable(sheetSourceModule);
        this.setNewTableUri(newTableUri);
        this.getModifiedWorkbooks().add(sheetSourceModule.getWorkbookSource());
        super.onFinish();
    }

    public void selectAction() {
        try {
            int index = Integer.parseInt(FacesUtils.getRequestParameter((String)"index"));
            if (this.actions.get(index) != null && this.validateAtStep4()) {
                this.actions.setSelectedIndex(index);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while selecting action", (Throwable)e);
        }
    }

    public void selectCondition() {
        try {
            int index = Integer.parseInt(FacesUtils.getRequestParameter((String)"index"));
            if (this.conditions.get(index) != null && this.validateAtStep3()) {
                this.conditions.setSelectedIndex(index);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while selecting condition", (Throwable)e);
        }
    }

    public void setOrientation(String or) {
        this.vertical = or != null && or.equals(ORIENTATATION_VERTICAL);
    }

    public void setParameters(List<TypeNamePair> parameters) {
        this.parameters = parameters;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public void useEditorLogicCondition() {
        TableCondition currentCondition = this.getCurrentCondition();
        if (currentCondition != null) {
            currentCondition.setLogicEditor(true);
        }
    }

    public void useManualLogicCondition() {
        TableCondition currentCondition = this.getCurrentCondition();
        if (currentCondition != null) {
            currentCondition.setLogicEditor(false);
        }
    }

    private boolean validateAfterStep5() {
        return this.validateParameterNames(this.returnValue.getParameters(), "newTableWiz5:paramTable:", ":pname");
    }

    private boolean validateAtStep3() {
        TableCondition cond = this.getCurrentCondition();
        return cond == null || this.validateParameterNames(cond.getParameters(), "newTableWiz3:paramTable:", ":pname");
    }

    private boolean validateAtStep4() {
        TableArtifact action = this.getCurrentAction();
        return action == null || this.validateParameterNames(action.getParameters(), "newTableWiz4:paramTable:", ":pname");
    }

    private boolean validateParameterNames(List<? extends TypeNamePair> parameters, String prefix, String suffix) {
        boolean res = true;
        for (int i = 0; i < parameters.size(); ++i) {
            String message = WizardUtils.checkParameterName(parameters.get(i).getName());
            if (message == null) continue;
            this.reportError(prefix + i + suffix, message);
            res = false;
        }
        return res;
    }
}

