/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.domaintree.DomainTree;
import org.openl.rules.domaintree.DomainTreeContext;
import org.openl.rules.ui.tablewizard.TypeNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainTreePath {
    private String dotExpression;
    private DomainTree domainTree;
    private DomainTreeContext context;
    private Collection<String> rootObjects;

    private boolean checkDotExpression(String dotExpression) {
        String typename = this.domainTree.getTypename(this.context, dotExpression);
        return typename != null;
    }

    public String getDotExpression() {
        return this.dotExpression;
    }

    public String getNewDotPart() {
        return "";
    }

    public Collection<String> getSubExpressions() {
        String typename = this.domainTree.getTypename(this.context, this.dotExpression);
        if (typename == null) {
            return this.rootObjects;
        }
        return this.domainTree.getClassProperties(typename);
    }

    public void setDomainTree(DomainTree domainTree) {
        this.domainTree = domainTree;
    }

    public void setDotExpression(String dotExpression) {
        this.dotExpression = dotExpression;
    }

    public void setNewDotPart(String newDotPart) {
        if (!StringUtils.isBlank((String)newDotPart)) {
            this.dotExpression = StringUtils.isBlank((String)this.dotExpression) ? newDotPart : this.dotExpression + "." + newDotPart;
        }
        if (!this.checkDotExpression(this.dotExpression)) {
            this.dotExpression = "";
        }
    }

    public void setParameters(List<TypeNamePair> parameters) {
        this.context = new DomainTreeContext();
        this.rootObjects = new ArrayList<String>(parameters.size());
        for (TypeNamePair pair : parameters) {
            this.context.setObjectType(pair.getName(), pair.getType());
            this.rootObjects.add(pair.getName());
        }
    }
}

