/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.model.SelectItem;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.tableeditor.renderkit.TableProperty;
import org.openl.rules.ui.EnumValuesUIHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBean {
    private List<TableProperty> properties = new ArrayList<TableProperty>();
    private String propNameToAdd;
    private TableProperty propToRemove;
    private Set<String> possibleToAddProps;
    private EnumValuesUIHelper enumHelper = new EnumValuesUIHelper();

    public PropertiesBean(List<String> possibleProperties) {
        this.possibleToAddProps = new HashSet<String>(possibleProperties);
    }

    public EnumValuesUIHelper getEnumHelper() {
        return this.enumHelper;
    }

    public String getPropNameToAdd() {
        return this.propNameToAdd;
    }

    public void setPropNameToAdd(String propNameToAdd) {
        this.propNameToAdd = propNameToAdd;
    }

    public TableProperty getPropToRemove() {
        return this.propToRemove;
    }

    public void setPropToRemove(TableProperty propToRemove) {
        this.propToRemove = propToRemove;
    }

    public List<TableProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<TableProperty> properties) {
        this.properties = properties;
        for (TableProperty property : properties) {
            this.possibleToAddProps.remove(property.getName());
        }
    }

    private TablePropertyDefinition getPropByName(String name) {
        return TablePropertyDefinitionUtils.getPropertyByName((String)name);
    }

    public List<SelectItem> getPropertiesThatCanBeAdded() {
        ArrayList<SelectItem> propertyNames = new ArrayList<SelectItem>();
        for (String propName : this.possibleToAddProps) {
            propertyNames.add(new SelectItem((Object)propName, this.getPropByName(propName).getDisplayName()));
        }
        return propertyNames;
    }

    public void addProperty() {
        TablePropertyDefinition propDefinition = this.getPropByName(this.propNameToAdd);
        Class propType = propDefinition.getType() == null ? String.class : propDefinition.getType().getInstanceClass();
        this.properties.add(new TableProperty.TablePropertyBuilder(propDefinition.getName(), propType).displayName(propDefinition.getDisplayName()).format(propDefinition.getFormat()).build());
        this.possibleToAddProps.remove(this.propNameToAdd);
    }

    public void addProperty(TableProperty property) {
        this.properties.add(property);
        this.possibleToAddProps.remove(property.getName());
    }

    public void removeProperty() {
        this.properties.remove(this.propToRemove);
        this.possibleToAddProps.add(this.propToRemove.getName());
    }
}

