/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.PropertiesTableBuilder;
import org.openl.rules.tableeditor.renderkit.TableProperty;
import org.openl.rules.ui.tablewizard.BusinessTableCreationWizard;
import org.openl.rules.ui.tablewizard.PropertiesBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTableCreationWizard
extends BusinessTableCreationWizard {
    private PropertiesBean propertiesManager;
    private String scopeType;
    private String tableName;
    private List<SelectItem> scopeTypes = new ArrayList<SelectItem>(Arrays.asList(new SelectItem((Object)"Module"), new SelectItem((Object)"Category")));

    public PropertiesBean getPropertiesManager() {
        return this.propertiesManager;
    }

    public List<SelectItem> getScopeTypes() {
        return this.scopeTypes;
    }

    public void setScopeTypes(List<SelectItem> scopeTypes) {
        this.scopeTypes = scopeTypes;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String next() {
        if (this.getStep() == 1) {
            this.propertiesManager = new PropertiesBean(this.getPropertyNamesList());
        }
        return super.next();
    }

    @Override
    protected void onStart() {
        this.reset();
        this.initWorkbooks();
    }

    @Override
    protected void onCancel() {
        this.reset();
    }

    @Override
    protected void reset() {
        super.reset();
    }

    @Override
    public String getName() {
        return "newTableProperty";
    }

    public List<String> getPropertyNamesList() {
        TablePropertyDefinition[] propDefinitions;
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (TablePropertyDefinition propDefinition : propDefinitions = TablePropertyDefinitionUtils.getDefaultDefinitionsByInheritanceLevel((InheritanceLevel)InheritanceLevel.valueOf((String)this.scopeType.toUpperCase()))) {
            String propName = propDefinition.getName();
            List<String> exceptProperties = this.getExceptProperties();
            if (exceptProperties.contains(propName)) continue;
            propertyNames.add(propName);
        }
        return propertyNames;
    }

    private List<String> getExceptProperties() {
        ArrayList<String> exceptProps = new ArrayList<String>();
        exceptProps.add("scope");
        exceptProps.add("category");
        return exceptProps;
    }

    @Override
    protected void onFinish() throws Exception {
        XlsSheetSourceCodeModule sheetSourceModule = this.getDestinationSheet();
        String newTableUri = this.buildTable(sheetSourceModule);
        this.setNewTableUri(newTableUri);
        this.getModifiedWorkbooks().add(sheetSourceModule.getWorkbookSource());
        super.onFinish();
    }

    protected String buildTable(XlsSheetSourceCodeModule sourceCodeModule) throws CreateTableException {
        XlsSheetGridModel gridModel = new XlsSheetGridModel(sourceCodeModule);
        PropertiesTableBuilder builder = new PropertiesTableBuilder(gridModel);
        Map<String, Object> properties = this.buildProperties();
        builder.beginTable(1 + properties.size());
        builder.writeHeader(this.tableName);
        builder.writeBody(properties);
        String uri = gridModel.getRangeUri(builder.getTableRegion());
        builder.endTable();
        return uri;
    }

    @Override
    protected Map<String, Object> buildProperties() {
        String categoryName;
        LinkedHashMap<String, Object> resultProperties = new LinkedHashMap<String, Object>();
        resultProperties.put("scope", this.scopeType);
        if (InheritanceLevel.CATEGORY.getDisplayName().equals(this.scopeType) && (categoryName = this.buildCategoryName()) != null) {
            resultProperties.put("category", categoryName);
        }
        for (TableProperty property : this.propertiesManager.getProperties()) {
            String name = property.getName();
            Object value = property.getValue();
            if (value == null || value != null && value instanceof String && StringUtils.isEmpty((String)((String)value))) continue;
            resultProperties.put(name.trim(), value);
        }
        return resultProperties;
    }
}

