/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import org.openl.rules.ui.copy.NewVersionTableCopier;
import org.openl.rules.ui.copy.TableNamesCopier;
import org.openl.rules.ui.copy.TablePropertyCopier;
import org.openl.rules.ui.tablewizard.TableWizard;

public class TableCopierWizardManager
extends TableWizard {
    private CopyType copyType = CopyType.CHANGE_NAMES;

    public TableCopierWizardManager() {
        this.init();
    }

    public String getCopyType() {
        return this.copyType.name();
    }

    public void setCopyType(String copyType) {
        try {
            this.copyType = CopyType.valueOf(copyType);
        }
        catch (IllegalArgumentException e) {
            this.copyType = CopyType.CHANGE_NAMES;
        }
    }

    public String startWizard() {
        this.reload();
        switch (this.copyType) {
            case CHANGE_NAMES: {
                this.wizard = new TableNamesCopier(this.getElementUri());
                break;
            }
            case CHANGE_PROPERTIES: {
                this.wizard = new TablePropertyCopier(this.getElementUri());
                break;
            }
            case CHANGE_VERSION: {
                this.wizard = new NewVersionTableCopier(this.getElementUri());
                break;
            }
            default: {
                return null;
            }
        }
        this.wizard.next();
        return this.wizard.getName();
    }

    public String cancel() {
        if (this.wizard != null) {
            this.wizard.cancel();
        }
        return "newTableCancel";
    }

    public String start() {
        this.copyType = CopyType.CHANGE_NAMES;
        return "wizardSelect";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CopyType {
        CHANGE_NAMES,
        CHANGE_PROPERTIES,
        CHANGE_VERSION;

    }
}

