/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import org.openl.rules.ui.tablewizard.DatatypeAliasTableCreationWizard;
import org.openl.rules.ui.tablewizard.DatatypeTableCreationWizard;
import org.openl.rules.ui.tablewizard.DecisionTableCreationWizard;
import org.openl.rules.ui.tablewizard.PropertyTableCreationWizard;
import org.openl.rules.ui.tablewizard.TableWizard;
import org.openl.rules.ui.tablewizard.TestTableCreationWizard;
import org.openl.rules.ui.tablewizard.TestTableCreationWizardDirect;

public class TableWizardManager
extends TableWizard {
    private TableType tableType = TableType.DECISION;

    public String cancel() {
        if (this.wizard != null) {
            this.wizard.cancel();
        }
        return "newTableCancel";
    }

    public String getTableType() {
        return this.tableType.name();
    }

    public void setTableType(String tableType) {
        try {
            this.tableType = TableType.valueOf(tableType);
        }
        catch (IllegalArgumentException e) {
            this.tableType = TableType.DECISION;
        }
    }

    public String start() {
        this.tableType = TableType.DECISION;
        return "wizardSelect";
    }

    public String startWizard() {
        this.reload();
        switch (this.tableType) {
            case DECISION: {
                this.wizard = new DecisionTableCreationWizard();
                this.wizard.setStepsCount(6);
                break;
            }
            case DATATYPE: {
                this.wizard = new DatatypeTableCreationWizard();
                this.wizard.setStepsCount(4);
                break;
            }
            case DATATYPE_ALIAS: {
                this.wizard = new DatatypeAliasTableCreationWizard();
                this.wizard.setStepsCount(4);
                break;
            }
            case TEST: {
                this.wizard = new TestTableCreationWizard();
                this.wizard.setStepsCount(4);
                break;
            }
            case TEST_DIRECT: {
                this.wizard = new TestTableCreationWizardDirect(this.getElementUri());
                this.wizard.setStepsCount(3);
                break;
            }
            case PROPERTY: {
                this.wizard = new PropertyTableCreationWizard();
                this.wizard.setStepsCount(3);
                break;
            }
            default: {
                return null;
            }
        }
        String ret = this.wizard.start();
        if ("error".equals(ret)) {
            return "";
        }
        this.wizard.next();
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TableType {
        UNKNOWN,
        DECISION,
        DATATYPE,
        DATATYPE_ALIAS,
        TEST,
        TEST_DIRECT,
        PROPERTY;

    }
}

