/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.NotEmpty;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.TestTableBuilder;
import org.openl.rules.ui.tablewizard.BusinessTableCreationWizard;
import org.openl.rules.ui.tablewizard.WizardUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTableCreationWizard
extends BusinessTableCreationWizard {
    private SelectItem[] tableItems;
    private int selectedTableNameIndex;
    @NotEmpty(message="Technical name can not be empty")
    @Pattern(regexp="([a-zA-Z_][a-zA-Z_0-9]*)?", message="Invalid technical name")
    private String technicalName;
    private List<TableSyntaxNode> executableTables;

    public String getTechnicalName() {
        return this.technicalName;
    }

    public void setTechnicalName(String technicalName) {
        this.technicalName = technicalName;
    }

    protected String getDefaultTechnicalName() {
        TableSyntaxNode node = this.getSelectedNode();
        String defaultName = TestTableBuilder.getDefaultTechnicalName((TableSyntaxNode)node);
        return defaultName;
    }

    protected TableSyntaxNode getSelectedNode() {
        List<TableSyntaxNode> nodes = this.getSyntaxNodes();
        if (this.selectedTableNameIndex < 0 || this.selectedTableNameIndex >= nodes.size()) {
            throw new IllegalStateException("Not table is selected");
        }
        return nodes.get(this.selectedTableNameIndex);
    }

    protected String buildTable(XlsSheetSourceCodeModule sourceCodeModule) throws CreateTableException {
        TableSyntaxNode node = this.getSelectedNode();
        String header = TestTableBuilder.getHeader((TableSyntaxNode)node, (String)this.technicalName);
        Map params = TestTableBuilder.getParams((TableSyntaxNode)node);
        XlsSheetGridModel gridModel = new XlsSheetGridModel(sourceCodeModule);
        TestTableBuilder builder = new TestTableBuilder(gridModel);
        Map<String, Object> properties = this.buildProperties();
        int width = params.size() + 1;
        if (width < 3 && !properties.isEmpty()) {
            width = 3;
        }
        int height = 3 + properties.size();
        builder.beginTable(width, height);
        builder.writeHeader(header, null);
        builder.writeProperties(properties, null);
        builder.writeParams(params, null);
        String uri = gridModel.getRangeUri(builder.getTableRegion());
        builder.endTable();
        return uri;
    }

    public SelectItem[] getDecisionTables() {
        return this.tableItems;
    }

    @Override
    public String getName() {
        return "newTestTable";
    }

    public int getSelectedTable() {
        return this.selectedTableNameIndex;
    }

    private List<TableSyntaxNode> getSyntaxNodes() {
        if (this.executableTables == null) {
            TableSyntaxNode[] syntaxNodes = WizardUtils.getMetaInfo().getXlsModuleNode().getXlsTableSyntaxNodesWithoutErrors();
            this.executableTables = new ArrayList<TableSyntaxNode>();
            for (TableSyntaxNode syntaxNode : syntaxNodes) {
                if (!this.isExecutableAndTestableNode(syntaxNode)) continue;
                this.executableTables.add(syntaxNode);
            }
        }
        return this.executableTables;
    }

    @Override
    protected void onCancel() {
        this.tableItems = null;
        this.reset();
    }

    @Override
    protected void onStart() {
        this.selectedTableNameIndex = 0;
        List<TableSyntaxNode> syntaxNodes = this.getSyntaxNodes();
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (int i = 0; i < syntaxNodes.size(); ++i) {
            TableSyntaxNode node = syntaxNodes.get(i);
            result.add(new SelectItem((Object)i, node.getMember().getName()));
        }
        this.tableItems = result.toArray(new SelectItem[result.size()]);
        Arrays.sort(this.tableItems, new Comparator<SelectItem>(){

            @Override
            public int compare(SelectItem o1, SelectItem o2) {
                return o1.getValue().toString().compareTo(o2.getValue().toString());
            }
        });
    }

    private boolean isExecutableAndTestableNode(TableSyntaxNode node) {
        return node.isExecutableNode() && !Void.TYPE.equals(node.getMember().getType().getInstanceClass());
    }

    @Override
    protected void onStepFirstVisit(int step) {
        if (step == 3) {
            this.initWorkbooks();
        }
    }

    @Override
    protected void onFinish() throws Exception {
        XlsSheetSourceCodeModule sheetSourceModule = this.getDestinationSheet();
        String newTableUri = this.buildTable(sheetSourceModule);
        this.setNewTableUri(newTableUri);
        this.getModifiedWorkbooks().add(sheetSourceModule.getWorkbookSource());
        super.onFinish();
    }

    public void setSelectedTable(int selectedTableNameIndex) {
        this.selectedTableNameIndex = selectedTableNameIndex;
        this.technicalName = this.getDefaultTechnicalName();
    }
}

