/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;
import org.openl.rules.lang.xls.syntax.WorkbookSyntaxNode;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.ui.tablewizard.WizardUtils;
import org.openl.rules.ui.tablewizard.jsf.BaseWizardBean;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.util.StringTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WizardBase
extends BaseWizardBean {
    private static final String SHEET_EXSISTING = "existing";
    private static final String SHEET_NEW = "new";
    private String workbook;
    private Integer worksheetIndex;
    private Map<String, XlsWorkbookSourceCodeModule> workbooks;
    private boolean newWorksheet;
    private boolean wizardFinised;
    private String newWorksheetName;
    private String newTableUri;
    private static final Log LOG = LogFactory.getLog(WizardBase.class);

    protected XlsSheetSourceCodeModule getDestinationSheet() {
        XlsSheetSourceCodeModule sourceCodeModule;
        XlsWorkbookSourceCodeModule module = this.workbooks.get(this.workbook);
        if (this.newWorksheet) {
            Sheet sheet = module.getWorkbook().createSheet(this.getNewWorksheetName());
            sourceCodeModule = new XlsSheetSourceCodeModule(sheet, this.getNewWorksheetName(), module);
        } else {
            Sheet sheet = module.getWorkbook().getSheetAt(this.getWorksheetIndex().intValue());
            sourceCodeModule = new XlsSheetSourceCodeModule(sheet, module.getWorkbook().getSheetName(this.getWorksheetIndex().intValue()), module);
        }
        return sourceCodeModule;
    }

    public String getNewWorksheet() {
        return this.newWorksheet ? SHEET_NEW : SHEET_EXSISTING;
    }

    public String getNewWorksheetName() {
        return this.newWorksheetName;
    }

    public String getWorkbook() {
        return this.workbook;
    }

    public List<SelectItem> getWorkbooks() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(this.workbooks.size());
        for (String wbURI : this.workbooks.keySet()) {
            String[] parts = wbURI.split("/");
            items.add(new SelectItem((Object)wbURI, parts[parts.length - 1]));
        }
        return items;
    }

    public Integer getWorksheetIndex() {
        return this.worksheetIndex;
    }

    public List<SelectItem> getWorksheets() {
        if (this.workbook == null || this.workbooks == null) {
            return Collections.emptyList();
        }
        XlsWorkbookSourceCodeModule currentSheet = this.workbooks.get(this.workbook);
        if (currentSheet == null) {
            return Collections.emptyList();
        }
        Workbook workbook = currentSheet.getWorkbook();
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(workbook.getNumberOfSheets());
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            items.add(new SelectItem((Object)i, workbook.getSheetName(i)));
        }
        return items;
    }

    protected void initWorkbooks() {
        WorkbookSyntaxNode[] syntaxNodes;
        this.workbooks = new HashMap<String, XlsWorkbookSourceCodeModule>();
        for (WorkbookSyntaxNode node : syntaxNodes = WizardUtils.getMetaInfo().getXlsModuleNode().getWorkbookSyntaxNodes()) {
            XlsWorkbookSourceCodeModule module = node.getWorkbookSourceCodeModule();
            this.workbooks.put(module.getUri(), module);
        }
        if (this.workbooks.size() > 0) {
            this.workbook = this.workbooks.keySet().iterator().next();
        }
    }

    public String getNewTableUri() {
        return this.newTableUri;
    }

    public void setNewTableUri(String newTableUri) {
        this.newTableUri = newTableUri;
    }

    protected void reset() {
        this.worksheetIndex = 0;
        this.workbooks = null;
        this.newWorksheet = false;
        this.wizardFinised = false;
        this.newWorksheetName = "";
        this.getModifiedWorkbooks().clear();
    }

    public void setNewWorksheet(String value) {
        this.newWorksheet = SHEET_NEW.equals(value);
    }

    public void setNewWorksheetName(String newWorksheetName) {
        this.newWorksheetName = newWorksheetName;
    }

    public void setWorkbook(String workbook) {
        this.workbook = workbook;
    }

    public void setWorksheetIndex(Integer worksheetIndex) {
        this.worksheetIndex = worksheetIndex;
    }

    @Override
    public String finish() {
        boolean success = false;
        try {
            if (!this.wizardFinised) {
                this.onFinish();
                this.wizardFinised = true;
            }
            this.doSave();
            success = true;
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Could not save table.", e.getMessage()));
            LOG.error((Object)"Could not save table: ", (Throwable)e);
        }
        if (success) {
            this.resetStudio();
            try {
                FacesUtils.redirect((String)this.makeUrlForNewTable());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private void resetStudio() {
        WebStudio studio = WebStudioUtils.getWebStudio();
        studio.rebuildModel();
    }

    protected String makeUrlForNewTable() {
        StringBuffer buffer = new StringBuffer(FacesUtils.getContextPath() + "/openTable.jsp");
        buffer.append("?uri=" + StringTool.encodeURL((String)this.newTableUri));
        return buffer.toString();
    }
}

