/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard;

import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.ui.tablewizard.TableArtifact;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardUtils {
    private static final Pattern REGEXP_PARAMETER = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");

    public static void autoRename(Collection<? extends TableArtifact> conditions, String prefix) {
        int i = 0;
        for (TableArtifact tableArtifact : conditions) {
            tableArtifact.setName(prefix + ++i);
        }
    }

    public static String checkParameterName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return "Parameter name can not be empty";
        }
        if (!WizardUtils.isValidParameter(name)) {
            return "Invalid name for parameter";
        }
        return null;
    }

    public static XlsMetaInfo getMetaInfo() {
        if (WizardUtils.getProjectOpenClass() instanceof NullOpenClass) {
            throw new IllegalArgumentException("Module is corrupted.");
        }
        return (XlsMetaInfo)WizardUtils.getProjectOpenClass().getMetaInfo();
    }

    public static IOpenClass getProjectOpenClass() {
        return WebStudioUtils.getWebStudio().getModel().getCompiledOpenClass().getOpenClassWithErrors();
    }

    public static boolean isValidParameter(String s) {
        return REGEXP_PARAMETER.matcher(s).matches();
    }
}

