/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tablewizard.jsf;

import java.util.HashSet;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.openl.rules.lang.xls.XlsWorkbookSourceCodeModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWizardBean {
    private int step;
    private int maxVisitedStep;
    private int stepsCount;
    private Set<XlsWorkbookSourceCodeModule> modifiedWorkbooks = new HashSet<XlsWorkbookSourceCodeModule>();

    public void cancel() {
        this.onCancel();
    }

    public Set<XlsWorkbookSourceCodeModule> getModifiedWorkbooks() {
        return this.modifiedWorkbooks;
    }

    public int getMaxVisitedStep() {
        return this.maxVisitedStep;
    }

    public String getName() {
        return "page";
    }

    public int getStep() {
        return this.step;
    }

    public String next() {
        this.setStep(this.getStep() + 1);
        if (this.getStep() == this.getMaxVisitedStep()) {
            this.onStepFirstVisit(this.getStep() + 1);
        }
        return "next";
    }

    public String prev() {
        --this.step;
        return "prev";
    }

    protected abstract void onCancel();

    protected abstract void onStart();

    protected void onFinish() throws Exception {
    }

    protected void doSave() throws Exception {
        for (XlsWorkbookSourceCodeModule workbook : this.modifiedWorkbooks) {
            workbook.save();
        }
    }

    protected void onStepFirstVisit(int step) {
    }

    public void setStep(int step) {
        this.step = step;
        this.maxVisitedStep = Math.max(step, this.maxVisitedStep);
    }

    public int getStepsCount() {
        return this.stepsCount;
    }

    public void setStepsCount(int stepsCount) {
        this.stepsCount = stepsCount;
    }

    public String start() {
        this.step = 0;
        this.maxVisitedStep = 0;
        try {
            this.onStart();
            return this.getName();
        }
        catch (IllegalArgumentException e) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "Can`t create wizard for this kind of table.", e.getMessage()));
            return "error";
        }
    }

    public String finish() throws Exception {
        this.onFinish();
        return null;
    }
}

