/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tree;

import org.apache.commons.lang.StringUtils;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.ui.TableSyntaxNodeUtils;
import org.openl.rules.ui.tree.BaseTableTreeNodeBuilder;
import org.openl.rules.ui.tree.ProjectTreeNode;

public class CategoryPropertiesTableNodeBuilder
extends BaseTableTreeNodeBuilder {
    private static final String FOLDER_NAME = "Category Properties";
    private static final String CATEGORY_PROPERTIES_TABLE = "Category Properties Table";

    public String[] getDisplayValue(Object nodeObject, int i) {
        TableSyntaxNode tableSyntaxNode = (TableSyntaxNode)nodeObject;
        return TableSyntaxNodeUtils.getTableDisplayValue(tableSyntaxNode, i);
    }

    public String getName() {
        return CATEGORY_PROPERTIES_TABLE;
    }

    public Object getProblems(Object nodeObject) {
        TableSyntaxNode tsn = (TableSyntaxNode)nodeObject;
        return tsn.getErrors() != null ? tsn.getErrors() : tsn.getValidationResult();
    }

    public String getType(Object nodeObject) {
        return "table group";
    }

    public String getUrl(Object nodeObject) {
        TableSyntaxNode tableSyntaxNode = (TableSyntaxNode)nodeObject;
        return tableSyntaxNode.getUri();
    }

    public int getWeight(Object nodeObject) {
        return 0;
    }

    protected Object makeObject(TableSyntaxNode tableSyntaxNode) {
        return tableSyntaxNode;
    }

    public boolean isBuilderApplicableForObject(TableSyntaxNode tableSyntaxNode) {
        return XlsNodeTypes.XLS_PROPERTIES.toString().equals(tableSyntaxNode.getType()) && this.isCategoryPropertyTable(tableSyntaxNode);
    }

    public ProjectTreeNode makeNode(TableSyntaxNode tableSyntaxNode, int i) {
        return this.makeFolderNode(FOLDER_NAME);
    }

    private boolean isCategoryPropertyTable(TableSyntaxNode tableSyntaxNode) {
        String propValue;
        boolean result = false;
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        if (tableProperties != null && StringUtils.isNotEmpty((String)(propValue = tableProperties.getScope())) && InheritanceLevel.CATEGORY.getDisplayName().equals(propValue)) {
            result = true;
        }
        return result;
    }

    private ProjectTreeNode makeFolderNode(String folderName) {
        return new ProjectTreeNode(new String[]{folderName, folderName, folderName}, "folder", null, null, 0, null);
    }
}

