/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tree;

import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.ui.tree.BaseTableTreeNodeBuilder;
import org.openl.rules.ui.tree.ModulePropertiesTableNodeBuilder;

public class CategoryTreeNodeBuilder
extends BaseTableTreeNodeBuilder {
    private static final String CATEGORY_BUILDER_NAME = "Category Builder";

    public String[] getDisplayValue(Object nodeObject, int i) {
        TableSyntaxNode tableSyntaxNode = (TableSyntaxNode)nodeObject;
        String category = this.getCategory(tableSyntaxNode);
        return new String[]{category, category, category};
    }

    public String getName() {
        return CATEGORY_BUILDER_NAME;
    }

    public String getType(Object nodeObject) {
        return "folder";
    }

    public String getUrl(Object nodeObject) {
        TableSyntaxNode tableSyntaxNode = (TableSyntaxNode)nodeObject;
        return tableSyntaxNode.getUri();
    }

    public int getWeight(Object nodeObject) {
        return 0;
    }

    public Object makeObject(TableSyntaxNode tableSyntaxNode) {
        return tableSyntaxNode;
    }

    public Object getProblems(Object nodeObject) {
        TableSyntaxNode tsn = (TableSyntaxNode)nodeObject;
        return tsn.getErrors() != null ? tsn.getErrors() : tsn.getValidationResult();
    }

    public boolean isBuilderApplicableForObject(TableSyntaxNode tableSyntaxNode) {
        return !XlsNodeTypes.XLS_PROPERTIES.toString().equals(tableSyntaxNode.getType()) || !ModulePropertiesTableNodeBuilder.isModulePropertyTable(tableSyntaxNode);
    }

    protected String getCategory(TableSyntaxNode tableSyntaxNode) {
        String category = null;
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        if (tableProperties != null && tableProperties.getCategory() != null) {
            category = tableProperties.getCategory();
        }
        if (category == null) {
            XlsSheetSourceCodeModule sheet = tableSyntaxNode.getXlsSheetSourceCodeModule();
            category = sheet.getSheetName();
        }
        return category;
    }
}

