/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tree;

import org.apache.commons.lang.StringUtils;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.ui.tree.BaseTableTreeNodeBuilder;
import org.openl.rules.ui.tree.ProjectTreeNode;

public class ModulePropertiesTableNodeBuilder
extends BaseTableTreeNodeBuilder {
    private static final String FOLDER_NAME = "Module Properties";
    private static final String MODULE_PROPERTIES_TABLE = "Module Properties Table";

    public String[] getDisplayValue(Object nodeObject, int i) {
        return new String[]{FOLDER_NAME, FOLDER_NAME, FOLDER_NAME};
    }

    public String getName() {
        return MODULE_PROPERTIES_TABLE;
    }

    public Object getProblems(Object nodeObject) {
        TableSyntaxNode tsn = (TableSyntaxNode)nodeObject;
        return tsn.getErrors() != null ? tsn.getErrors() : tsn.getValidationResult();
    }

    public String getType(Object nodeObject) {
        return "table group";
    }

    public String getUrl(Object nodeObject) {
        TableSyntaxNode tableSyntaxNode = (TableSyntaxNode)nodeObject;
        return tableSyntaxNode.getUri();
    }

    public int getWeight(Object nodeObject) {
        return 0;
    }

    protected Object makeObject(TableSyntaxNode tableSyntaxNode) {
        return tableSyntaxNode;
    }

    public boolean isBuilderApplicableForObject(TableSyntaxNode tableSyntaxNode) {
        return XlsNodeTypes.XLS_PROPERTIES.toString().equals(tableSyntaxNode.getType()) && ModulePropertiesTableNodeBuilder.isModulePropertyTable(tableSyntaxNode);
    }

    public ProjectTreeNode makeNode(TableSyntaxNode tableSyntaxNode, int i) {
        String folderName = FOLDER_NAME;
        return this.makeFolderNode(folderName);
    }

    public static boolean isModulePropertyTable(TableSyntaxNode tableSyntaxNode) {
        String propValue;
        boolean result = false;
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        if (tableProperties != null && StringUtils.isNotEmpty((String)(propValue = tableProperties.getScope())) && InheritanceLevel.MODULE.getDisplayName().equals(propValue)) {
            result = true;
        }
        return result;
    }

    private ProjectTreeNode makeFolderNode(String folderName) {
        return new ProjectTreeNode(new String[]{folderName, folderName, folderName}, "folder", null, null, 0, null);
    }
}

