/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeKey;
import org.openl.rules.ui.OverloadedMethodsDictionary;
import org.openl.rules.ui.TableSyntaxNodeUtils;
import org.openl.rules.ui.tree.NodeKey;
import org.openl.rules.ui.tree.OpenMethodsGroupTreeNodeBuilder;
import org.openl.rules.ui.tree.ProjectTreeNode;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.MethodKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMethodInstancesGroupTreeNodeBuilder
extends OpenMethodsGroupTreeNodeBuilder {
    private static final String TABLE_INSTANCES_GROUP_NAME = "Table Group Instance";

    @Override
    public String[] getDisplayValue(Object nodeObject, int i) {
        TableSyntaxNode tableSyntaxNode = (TableSyntaxNode)nodeObject;
        return TableSyntaxNodeUtils.getTableDisplayValue(tableSyntaxNode, i);
    }

    @Override
    public String getName() {
        return TABLE_INSTANCES_GROUP_NAME;
    }

    @Override
    public String getType(Object sorterObject) {
        return "table group";
    }

    @Override
    public String getUrl(Object sorterObject) {
        return null;
    }

    @Override
    public int getWeight(Object sorterObject) {
        return 0;
    }

    @Override
    public Object makeObject(TableSyntaxNode tableSyntaxNode) {
        return tableSyntaxNode;
    }

    @Override
    public boolean isBuilderApplicableForObject(TableSyntaxNode tableSyntaxNode) {
        if (tableSyntaxNode.getMember() instanceof IOpenMethod) {
            Set<TableSyntaxNodeKey> methodOverloads;
            IOpenMethod method = (IOpenMethod)tableSyntaxNode.getMember();
            OverloadedMethodsDictionary openMethodGroupsDictionary = this.getOpenMethodGroupsDictionary();
            if (openMethodGroupsDictionary.contains(method) && (methodOverloads = openMethodGroupsDictionary.getAllMethodOverloads(method)) != null && methodOverloads.size() > 1) {
                return true;
            }
        }
        return false;
    }

    public ProjectTreeNode makeNode(TableSyntaxNode tableSyntaxNode, int i) {
        IOpenMethod method = (IOpenMethod)tableSyntaxNode.getMember();
        String folderName = this.getFolderName(method);
        return this.makeFolderNode(folderName);
    }

    private String getFolderName(IOpenMethod method) {
        OverloadedMethodsDictionary openMethodGroupsDictionary = this.getOpenMethodGroupsDictionary();
        Set<TableSyntaxNodeKey> methodOverloads = openMethodGroupsDictionary.getAllMethodOverloads(method);
        String folderName = this.getMajorityName(methodOverloads);
        return folderName;
    }

    @Override
    public Comparable<?> makeKey(TableSyntaxNode tableSyntaxNode, int i) {
        if (tableSyntaxNode.getMember() instanceof IOpenMethod) {
            IOpenMethod method = (IOpenMethod)tableSyntaxNode.getMember();
            MethodKey methodKey = new MethodKey(method);
            String keyString = methodKey.toString();
            String folderName = this.getFolderName(method);
            Object nodeObject = this.makeObject(tableSyntaxNode);
            String[] displayNames = new String[3];
            for (int k = 0; k < displayNames.length; ++k) {
                displayNames[k] = folderName + keyString;
            }
            return new NodeKey(this.getWeight(nodeObject), displayNames);
        }
        return null;
    }

    @Override
    public Object getProblems(Object nodeObject) {
        TableSyntaxNode tsn = (TableSyntaxNode)nodeObject;
        return tsn.getErrors() != null ? tsn.getErrors() : tsn.getValidationResult();
    }

    private String getMajorityName(Set<TableSyntaxNodeKey> overloads) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (TableSyntaxNodeKey oneOverloadVariant : overloads) {
            String[] names = this.getDisplayValue(oneOverloadVariant.getTableSyntaxNode(), 0);
            String name = names[0];
            Integer value = (Integer)map.get(name);
            if (value == null) {
                value = 0;
            }
            value = value + 1;
            map.put(name, value);
        }
        Integer maxNameWeight = 0;
        String majorName = "";
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            if (maxNameWeight.compareTo((Integer)entry.getValue()) >= 0) continue;
            maxNameWeight = (Integer)entry.getValue();
            majorName = (String)entry.getKey();
        }
        return majorName;
    }

    private ProjectTreeNode makeFolderNode(String folderName) {
        return new ProjectTreeNode(new String[]{folderName, folderName, folderName}, "folder", null, null, 0, null);
    }
}

