/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tree;

import java.util.Iterator;
import org.openl.base.INamedThing;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.ui.tree.ITreeNode;
import org.openl.rules.ui.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTreeNode
extends TreeNode<Object>
implements INamedThing {
    private String uri;
    private String[] displayName;
    private int nameCount = 0;
    private TableSyntaxNode tableSyntaxNode;
    private Object problems;

    public ProjectTreeNode(String[] displayName, String type, String uri, Object problems, int nameCount, TableSyntaxNode tsn) {
        this.setType(type);
        this.uri = uri;
        this.displayName = displayName;
        this.problems = problems;
        this.nameCount = nameCount;
        this.tableSyntaxNode = tsn;
    }

    public String[] getDisplayName() {
        return this.displayName;
    }

    public String getDisplayName(int mode) {
        return this.displayName[mode];
    }

    public String getName() {
        return this.getDisplayName(0);
    }

    public int getNameCount() {
        return this.nameCount;
    }

    public Object getProblems() {
        return this.problems;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean hasProblems() {
        if (this.problems != null) {
            return true;
        }
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            ProjectTreeNode projectTreeNode;
            ITreeNode treeNode = iterator.next();
            if (!(treeNode instanceof ProjectTreeNode) || !(projectTreeNode = (ProjectTreeNode)treeNode).hasProblems()) continue;
            return true;
        }
        return false;
    }

    public void setProblems(Object problems) {
        this.problems = problems;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public TableSyntaxNode getTableSyntaxNode() {
        return this.tableSyntaxNode;
    }
}

