/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tree;

import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeKey;
import org.openl.rules.ui.TableSyntaxNodeUtils;
import org.openl.rules.ui.tree.ITreeNode;
import org.openl.rules.ui.tree.NodeKey;
import org.openl.rules.ui.tree.OpenMethodsGroupTreeNodeBuilder;
import org.openl.rules.ui.tree.VersionedTreeNode;
import org.openl.types.IOpenMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInstanceTreeNodeBuilder
extends OpenMethodsGroupTreeNodeBuilder {
    private static final String TABLE_INSTANCE_NAME = "Table Instance";

    @Override
    public String[] getDisplayValue(Object sorterObject, int i) {
        TableSyntaxNode tsn = (TableSyntaxNode)sorterObject;
        return TableSyntaxNodeUtils.getTableDisplayValue(tsn, i, this.getOpenMethodGroupsDictionary());
    }

    @Override
    public String getName() {
        return TABLE_INSTANCE_NAME;
    }

    @Override
    public Object getProblems(Object nodeObject) {
        TableSyntaxNode tsn = (TableSyntaxNode)nodeObject;
        return tsn.getErrors() != null ? tsn.getErrors() : tsn.getValidationResult();
    }

    @Override
    public String getType(Object sorterObject) {
        TableSyntaxNode tsn = (TableSyntaxNode)sorterObject;
        return "table." + tsn.getType();
    }

    @Override
    public String getUrl(Object sorterObject) {
        TableSyntaxNode tsn = (TableSyntaxNode)sorterObject;
        return tsn.getUri();
    }

    @Override
    public int getWeight(Object sorterObject) {
        return 0;
    }

    @Override
    public boolean isUnique(TableSyntaxNode tsn) {
        return XlsNodeTypes.XLS_PROPERTIES.toString().equals(tsn.getType()) || XlsNodeTypes.XLS_DATATYPE.toString().equals(tsn.getType()) || XlsNodeTypes.XLS_ENVIRONMENT.toString().equals(tsn.getType());
    }

    @Override
    public Object makeObject(TableSyntaxNode tsn) {
        return tsn;
    }

    @Override
    public Comparable<?> makeKey(TableSyntaxNode tableSyntaxNode) {
        if (tableSyntaxNode.getMember() instanceof IOpenMethod) {
            TableSyntaxNodeKey key = new TableSyntaxNodeKey(tableSyntaxNode);
            String keyString = key.toString();
            Object nodeObject = this.makeObject(tableSyntaxNode);
            String[] displayNames = this.getDisplayValue(tableSyntaxNode, 0);
            int i = 0;
            while (i < displayNames.length) {
                int n = i++;
                displayNames[n] = displayNames[n] + keyString;
            }
            return new NodeKey(this.getWeight(nodeObject), displayNames);
        }
        return super.makeKey(tableSyntaxNode);
    }

    @Override
    public ITreeNode<Object> makeNode(TableSyntaxNode tableSyntaxNode, int i) {
        Object nodeObject = this.makeObject(tableSyntaxNode);
        String[] displayNames = this.getDisplayValue(nodeObject, 0);
        VersionedTreeNode projectTreeNode = new VersionedTreeNode(displayNames, tableSyntaxNode);
        projectTreeNode.setObject(nodeObject);
        return projectTreeNode;
    }
}

