/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tree;

import java.util.HashMap;
import java.util.Map;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.ui.tree.BaseTableTreeNodeBuilder;
import org.openl.rules.ui.tree.NodeKey;

public class TableTreeNodeBuilder
extends BaseTableTreeNodeBuilder {
    private static final String OTHER_NODE_KEY = "Other";
    private static final String TABLE_TYPE_NAME = "Table Type";
    private Map<String, NodeKey> nodeKeysMap;

    public TableTreeNodeBuilder() {
        this.init();
    }

    private void init() {
        this.nodeKeysMap = new HashMap<String, NodeKey>();
        this.nodeKeysMap.put(XlsNodeTypes.XLS_DT.toString(), new NodeKey(0, new String[]{"Decision", "Decision Tables", ""}));
        this.nodeKeysMap.put(XlsNodeTypes.XLS_SPREADSHEET.toString(), new NodeKey(1, new String[]{"Spreadsheet", "Spreadsheet Tables", ""}));
        this.nodeKeysMap.put(XlsNodeTypes.XLS_SPREADSHEET.toString(), new NodeKey(1, new String[]{"Spreadsheet", "Spreadsheet Tables", ""}));
        this.nodeKeysMap.put(XlsNodeTypes.XLS_TBASIC.toString(), new NodeKey(2, new String[]{"TBasic", "Structured Algorithm Tables", ""}));
        this.nodeKeysMap.put(XlsNodeTypes.XLS_COLUMN_MATCH.toString(), new NodeKey(3, new String[]{"Column Match", "Column Match Tables", ""}));
        this.nodeKeysMap.put(XlsNodeTypes.XLS_DATA.toString(), new NodeKey(4, new String[]{"Data", "Data Tables", ""}));
        this.nodeKeysMap.put(XlsNodeTypes.XLS_TEST_METHOD.toString(), new NodeKey(5, new String[]{"Test", "Tables with data for method unit tests", ""}));
        this.nodeKeysMap.put(XlsNodeTypes.XLS_RUN_METHOD.toString(), new NodeKey(5, new String[]{"Run", "Tables with run data for methods", ""}));
        this.nodeKeysMap.put(XlsNodeTypes.XLS_DATATYPE.toString(), new NodeKey(6, new String[]{"Datatype", "OpenL Datatypes", ""}));
        this.nodeKeysMap.put(XlsNodeTypes.XLS_METHOD.toString(), new NodeKey(7, new String[]{"Method", "OpenL Methods", ""}));
        this.nodeKeysMap.put(XlsNodeTypes.XLS_ENVIRONMENT.toString(), new NodeKey(8, new String[]{"Configuration", "Environment table, used to configure OpenL project", ""}));
        this.nodeKeysMap.put(OTHER_NODE_KEY, new NodeKey(10, new String[]{OTHER_NODE_KEY, "The Tables that do not belong to any known OpenL type", ""}));
        this.nodeKeysMap.put(XlsNodeTypes.XLS_PROPERTIES.toString(), new NodeKey(11, new String[]{"Properties", "Properties Tables", ""}));
    }

    public String[] getDisplayValue(Object nodeObject, int i) {
        NodeKey nodeKey = this.getNodeKey(nodeObject);
        return nodeKey.getValue();
    }

    public String getName() {
        return TABLE_TYPE_NAME;
    }

    public String getType(Object nodeObject) {
        return "folder";
    }

    public String getUrl(Object nodeObject) {
        return null;
    }

    public int getWeight(Object nodeObject) {
        NodeKey nodeKey = this.getNodeKey(nodeObject);
        return nodeKey.getWeight();
    }

    public Object makeObject(TableSyntaxNode tableSyntaxNode) {
        return tableSyntaxNode;
    }

    public Object getProblems(Object nodeObject) {
        TableSyntaxNode tsn = (TableSyntaxNode)nodeObject;
        return tsn.getErrors() != null ? tsn.getErrors() : tsn.getValidationResult();
    }

    private NodeKey getNodeKey(Object nodeObject) {
        TableSyntaxNode tsn = (TableSyntaxNode)nodeObject;
        String type = tsn.getType();
        NodeKey nodeKey = this.nodeKeysMap.get(type);
        if (nodeKey == null) {
            nodeKey = this.nodeKeysMap.get(OTHER_NODE_KEY);
        }
        return nodeKey;
    }
}

