/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tree;

import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.ui.tree.ITreeNode;
import org.openl.rules.ui.tree.ProjectTreeNode;
import org.openl.util.conf.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedTreeNode
extends ProjectTreeNode {
    private static Log LOG = LogFactory.getLog(VersionedTreeNode.class);
    private TableSyntaxNode linkedChild;

    public VersionedTreeNode(String[] displayName, TableSyntaxNode table) {
        super(displayName, "table." + table.getType(), null, null, 0, null);
    }

    @Override
    public String getType() {
        return "table." + this.linkedChild.getType();
    }

    @Override
    public String getUri() {
        return this.linkedChild.getUri();
    }

    @Override
    public Object getProblems() {
        return this.linkedChild.getErrors() != null ? this.linkedChild.getErrors() : this.linkedChild.getValidationResult();
    }

    @Override
    public boolean hasProblems() {
        return this.getProblems() != null;
    }

    @Override
    public TableSyntaxNode getTableSyntaxNode() {
        return this.linkedChild;
    }

    @Override
    public TreeMap<Object, ITreeNode<Object>> getElements() {
        TreeMap<Object, ITreeNode<Object>> elements = super.getElements();
        if (elements.size() < 2) {
            return new TreeMap<Object, ITreeNode<Object>>();
        }
        return elements;
    }

    @Override
    public boolean isLeaf() {
        return this.getElements().size() < 1;
    }

    @Override
    public Iterator<ITreeNode<Object>> getChildren() {
        return this.getElements().values().iterator();
    }

    @Override
    public void addChild(Object key, ITreeNode<Object> child) {
        super.addChild(key, child);
        ProjectTreeNode newChild = (ProjectTreeNode)child;
        if (this.linkedChild == null) {
            this.linkedChild = newChild.getTableSyntaxNode();
        } else if (VersionedTreeNode.findLaterTable(this.linkedChild, newChild.getTableSyntaxNode()) > 0) {
            this.linkedChild = newChild.getTableSyntaxNode();
        }
    }

    public static int findLaterTable(TableSyntaxNode first, TableSyntaxNode second) {
        if (first.getTableProperties().getActive() != null) {
            if (first.getTableProperties().getActive().booleanValue()) {
                return -1;
            }
            if (second.getTableProperties().getActive().booleanValue()) {
                return 1;
            }
        } else {
            return 0;
        }
        try {
            Version firstNodeVersion = Version.parseVersion((String)first.getTableProperties().getVersion(), (int)0, (String)"..");
            Version secondNodeVersion = Version.parseVersion((String)second.getTableProperties().getVersion(), (int)0, (String)"..");
            return secondNodeVersion.compareTo(firstNodeVersion);
        }
        catch (RuntimeException e) {
            LOG.error((Object)e);
            return 0;
        }
    }
}

