/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tree.richfaces;

import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.ui.ProjectModel;
import org.openl.rules.ui.tree.ProjectTreeNode;
import org.openl.rules.ui.tree.richfaces.TreeBuilder;
import org.openl.util.StringTool;
import org.openl.util.tree.ITreeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTreeBuilder
extends TreeBuilder {
    private ProjectModel projectModel;

    public ProjectTreeBuilder(ITreeElement<?> root, ProjectModel projectModel) {
        super(root);
        this.projectModel = projectModel;
    }

    @Override
    protected int getState(ITreeElement<?> element) {
        ProjectTreeNode pte = (ProjectTreeNode)element;
        if (pte.hasProblems()) {
            return 1;
        }
        if (pte.getTableSyntaxNode() != null && this.projectModel.isTestable(pte.getTableSyntaxNode())) {
            return 2;
        }
        return super.getState(element);
    }

    @Override
    protected boolean isActive(ITreeElement<?> element) {
        Boolean active;
        ITableProperties tableProperties;
        ProjectTreeNode projectNode = (ProjectTreeNode)element;
        TableSyntaxNode syntaxNode = projectNode.getTableSyntaxNode();
        if (syntaxNode != null && (tableProperties = syntaxNode.getTableProperties()) != null && (active = tableProperties.getActive()) != null) {
            return active;
        }
        return super.isActive(element);
    }

    @Override
    protected String getUrl(ITreeElement<?> element) {
        String elementType = element.getType();
        if (elementType.startsWith("table.")) {
            String uri = ((ProjectTreeNode)element).getUri();
            return "tableeditor/showTable.xhtml?uri=" + StringTool.encodeURL((String)uri);
        }
        return null;
    }
}

