/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tree.richfaces;

import java.util.Iterator;
import org.openl.base.INamedThing;
import org.openl.rules.ui.tree.AbstractTreeBuilder;
import org.openl.rules.ui.tree.TreeNodeData;
import org.openl.util.tree.ITreeElement;
import org.richfaces.model.TreeNode;
import org.richfaces.model.TreeNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBuilder
extends AbstractTreeBuilder<TreeNode<?>> {
    private ITreeElement<?> root;

    public TreeBuilder(ITreeElement<?> root) {
        this.root = root;
    }

    @Override
    public TreeNode<?> build() {
        return this.build(false);
    }

    public TreeNode<?> build(boolean hasRoot) {
        TreeNodeImpl rfTree = new TreeNodeImpl();
        this.addNodes((TreeNode<?>)rfTree, this.root);
        if (hasRoot) {
            TreeNodeData data = this.getNodeData(this.root);
            rfTree.setData((Object)data);
            TreeNodeImpl rfRoot = new TreeNodeImpl();
            rfRoot.addChild((Object)0, (TreeNode)rfTree);
            return rfRoot;
        }
        return rfTree;
    }

    private void addNodes(TreeNode<?> rfParent, ITreeElement<?> parent) {
        int index = 1;
        Iterator pi = parent.getChildren();
        while (pi.hasNext()) {
            ITreeElement child = (ITreeElement)pi.next();
            TreeNode<?> rfChild = this.toRFNode(child);
            rfParent.addChild((Object)index, rfChild);
            this.addNodes(rfChild, child);
            ++index;
        }
    }

    private TreeNode<?> toRFNode(ITreeElement<?> node) {
        TreeNodeImpl rfNode = new TreeNodeImpl();
        TreeNodeData data = this.getNodeData(node);
        rfNode.setData((Object)data);
        return rfNode;
    }

    protected TreeNodeData getNodeData(ITreeElement<?> node) {
        String name = this.getDisplayName(node, 0);
        String title = this.getDisplayName(node, 1);
        String url = this.getUrl(node);
        String type = this.getType(node);
        int state = this.getState(node);
        boolean active = this.isActive(node);
        TreeNodeData nodeData = new TreeNodeData(name, title, url, state, type, active);
        return nodeData;
    }

    protected boolean isActive(ITreeElement<?> element) {
        return true;
    }

    protected String getType(ITreeElement<?> element) {
        String type = element.getType();
        if (type != null) {
            return type;
        }
        return "";
    }

    protected String getUrl(ITreeElement<?> element) {
        return "";
    }

    protected String getDisplayName(Object obj, int mode) {
        if (obj instanceof INamedThing) {
            INamedThing nt = (INamedThing)obj;
            return nt.getDisplayName(mode);
        }
        return String.valueOf(obj);
    }

    protected int getState(ITreeElement<?> element) {
        return 0;
    }
}

