/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui.tree.richfaces;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.richfaces.component.UITree;
import org.richfaces.component.state.TreeStateAdvisor;
import org.richfaces.model.TreeRowKey;

public class TreeStateManager
implements TreeStateAdvisor {
    public static final String TREE_NODE_KEY_SEPARATOR = ":";
    private String nodeToOpen;
    private String[] nodePathToOpen;
    private int openedNodesNumber = 0;

    public TreeStateManager() {
    }

    public TreeStateManager(String nodeToOpen) {
        this.setNodeToOpen(nodeToOpen);
    }

    public void setNodeToOpen(String nodeToOpen) {
        this.nodeToOpen = nodeToOpen;
        if (StringUtils.isNotBlank((String)nodeToOpen)) {
            this.nodePathToOpen = nodeToOpen.split(TREE_NODE_KEY_SEPARATOR);
        }
    }

    public Boolean adviseNodeOpened(UITree tree) {
        if (!ArrayUtils.isEmpty((Object[])this.nodePathToOpen)) {
            String currentNode = ((TreeRowKey)tree.getRowKey()).getPath();
            String nodeToOpen = "";
            int nodesToOpenNumber = this.nodePathToOpen.length;
            if (nodesToOpenNumber > this.openedNodesNumber) {
                for (int i = 0; i < this.openedNodesNumber + 1; ++i) {
                    nodeToOpen = nodeToOpen + this.nodePathToOpen[i];
                    if (i >= this.openedNodesNumber) continue;
                    nodeToOpen = nodeToOpen + TREE_NODE_KEY_SEPARATOR;
                }
            }
            if (nodeToOpen.equals(currentNode)) {
                ++this.openedNodesNumber;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Boolean adviseNodeSelected(UITree tree) {
        String currentNode;
        if (StringUtils.isNotBlank((String)this.nodeToOpen) && this.nodeToOpen.equals(currentNode = ((TreeRowKey)tree.getRowKey()).getPath())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

