/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.filter;

import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.openl.rules.workspace.abstracts.ProjectResource;
import org.openl.util.filter.BaseOpenLFilter;

public class RepositoryFileExtensionFilter
extends BaseOpenLFilter {
    private final String[] extensions;

    public RepositoryFileExtensionFilter(String extensionList) {
        HashSet<String> extSet = new HashSet<String>();
        for (String ext : extensionList.split(";")) {
            if (StringUtils.isBlank((String)ext)) continue;
            extSet.add(ext.trim());
        }
        this.extensions = extSet.toArray(new String[extSet.size()]);
        for (int i = 0; i < this.extensions.length; ++i) {
            if (this.extensions[i].startsWith(".")) continue;
            this.extensions[i] = "." + this.extensions[i];
        }
    }

    public boolean select(Object obj) {
        ProjectResource res = (ProjectResource)obj;
        for (String ext : this.extensions) {
            if (!res.getName().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public boolean supports(Class aClass) {
        return ProjectResource.class.isAssignableFrom(aClass);
    }
}

