/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionTimeoutFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(SessionTimeoutFilter.class);
    private static final int REDIRECT_ERROR_CODE = 399;
    private FilterConfig config;
    private String redirectPage;
    private String[] excludePages;

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (this.excludePages != null && this.excludePages.length > 0) {
            for (String excludePage : this.excludePages) {
                if (excludePage.equals("") || request.getRequestURL().indexOf(excludePage) <= -1) continue;
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
        }
        if (request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid()) {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String redirect = request.getContextPath() + this.redirectPage;
            LOG.info((Object)("Session Timeout filter: redirect to " + this.redirectPage + " page"));
            String xRequested = request.getHeader("X-Requested-With");
            if (xRequested != null && xRequested.equalsIgnoreCase("XMLHttpRequest")) {
                response.setHeader("Location", redirect);
                response.sendError(399, "Redirect Error");
            } else {
                response.sendRedirect(redirect);
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String excludePagesStr;
        this.config = filterConfig;
        this.redirectPage = this.config.getInitParameter("redirectPage");
        if (this.redirectPage == null) {
            this.redirectPage = "";
            LOG.warn((Object)"Session Timeout filter: could not get an initial parameter 'redirectPage'");
        }
        if ((excludePagesStr = this.config.getInitParameter("excludePages")) != null) {
            this.excludePages = excludePagesStr.split(",");
        }
    }
}

