/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.filter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public class WebResourceFilter
implements Filter {
    private static final String WEBRESOURCE_PREFIX = "/webresource";
    private FilterConfig filterConfig;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getRequestURI();
        if (path != null && path.indexOf(WEBRESOURCE_PREFIX) != -1) {
            InputStream stream = WebResourceFilter.class.getResourceAsStream(path = path.substring(path.lastIndexOf(WEBRESOURCE_PREFIX) + WEBRESOURCE_PREFIX.length()));
            if (stream == null) {
                stream = new FileInputStream(new File(this.filterConfig.getServletContext().getRealPath(path)));
            }
            ServletOutputStream out = response.getOutputStream();
            IOUtils.copy((InputStream)stream, (OutputStream)out);
            stream.close();
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }
}

