/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.properties;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.xls.formatters.XlsDateFormatter;
import org.openl.rules.webstudio.properties.CurrentDateValue;
import org.openl.rules.webstudio.properties.CurrentUserValue;
import org.openl.rules.webstudio.properties.ISystemValue;

public class SystemValuesManager {
    private Map<String, ISystemValue> systemValues = new HashMap<String, ISystemValue>();
    private static volatile SystemValuesManager instance;
    private final String currentUserDescription = "currentUser";
    private final String currentDatedescription = "currentDate";

    private SystemValuesManager() {
        for (TablePropertyDefinition propDef : TablePropertyDefinitionUtils.getSystemProperties()) {
            if ("currentUser".equals(propDef.getSystemValueDescriptor())) {
                if (this.systemValues.containsKey("currentUser")) continue;
                this.systemValues.put("currentUser", new CurrentUserValue());
                continue;
            }
            if (!"currentDate".equals(propDef.getSystemValueDescriptor()) || this.systemValues.containsKey("currentDate")) continue;
            this.systemValues.put("currentDate", new CurrentDateValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SystemValuesManager getInstance() {
        if (instance != null) return instance;
        Class<SystemValuesManager> clazz = SystemValuesManager.class;
        synchronized (SystemValuesManager.class) {
            if (instance != null) return instance;
            instance = new SystemValuesManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Object getSystemValue(String descriptor) {
        Object result = null;
        ISystemValue systemValue = this.systemValues.get(descriptor);
        if (systemValue != null) {
            result = systemValue.getValue();
        }
        return result;
    }

    public String getSystemValueString(String descriptor) {
        String result = null;
        Object resultValue = null;
        ISystemValue systemValue = this.systemValues.get(descriptor);
        if (systemValue != null && (resultValue = systemValue.getValue()) != null) {
            if (resultValue instanceof Date) {
                SimpleDateFormat format = new SimpleDateFormat(XlsDateFormatter.DEFAULT_JAVA_DATE_FORMAT);
                result = format.format((Date)resultValue);
            } else {
                result = resultValue.toString();
            }
        }
        return result;
    }
}

