/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.util;

public class NameChecker {
    private static final char[] FORBIDDEN_CHARS = new char[]{'\\', '/', ':', ';', '<', '>', '?', '*', '%', '\''};
    private static String forbiddenChars;
    public static final String BAD_NAME_MSG;

    protected static boolean checkForbiddenChars(String artefactName) {
        for (char c : FORBIDDEN_CHARS) {
            if (artefactName.indexOf(c) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean checkName(String artefactName) {
        if (!NameChecker.checkForbiddenChars(artefactName)) {
            return false;
        }
        if (!NameChecker.checkSpecialChars(artefactName)) {
            return false;
        }
        if (artefactName.startsWith(" ")) {
            return false;
        }
        if (artefactName.endsWith(" ")) {
            return false;
        }
        return !artefactName.endsWith(".");
    }

    protected static boolean checkSpecialChars(String artefactName) {
        for (int i = 0; i < artefactName.length(); ++i) {
            if (artefactName.charAt(i) >= ' ') continue;
            return false;
        }
        return true;
    }

    public static String getForbiddenCharacters() {
        if (forbiddenChars == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < FORBIDDEN_CHARS.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(FORBIDDEN_CHARS[i]);
            }
            forbiddenChars = sb.toString();
        }
        return forbiddenChars;
    }

    static {
        BAD_NAME_MSG = "Name must not contain forbidden characters (" + NameChecker.getForbiddenCharacters() + "), special characters, start with space, end with space or dot!";
    }
}

