/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.webstudio.util;

import edu.stanford.ejalbert.BrowserLauncher;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.text.MessageFormat;
import org.openl.main.OpenLVersion;
import org.openl.util.Log;
import org.openl.util.StringTool;

public class StartTomcat {
    private static final String BROWSER_URL_PROPERTY = "browser.url";
    private static final String DEFAULT_BROWSER_URL = "http://localhost:8080/webstudio/";
    public static final String JAVA_CLASSPATH_PROPERTY = "java.class.path";

    private static String findChome() throws IOException {
        String cpath = System.getProperty(JAVA_CLASSPATH_PROPERTY);
        String[] pathElements = StringTool.tokenize((String)cpath, (String)File.pathSeparator);
        for (int i = 0; i < pathElements.length; ++i) {
            if (!pathElements[i].endsWith("bootstrap.jar")) continue;
            File tomcatHome = new File(pathElements[i]).getCanonicalFile().getParentFile().getParentFile();
            return tomcatHome.toString();
        }
        throw new RuntimeException("Could not find bootstrap.jar in java.class.path");
    }

    private static String getProperty(String[] args, String prefix) {
        if (args != null) {
            for (String parameter : args) {
                if (!parameter.startsWith(prefix)) continue;
                return parameter.substring(parameter.indexOf(61) + 1).trim();
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        File catalinaHome;
        File webstudioHome;
        System.out.println("OpenL Tomcat Starter,  Version " + OpenLVersion.getVersion() + " Build " + OpenLVersion.getBuild() + " " + OpenLVersion.getURL() + " (c) " + OpenLVersion.getCopyrightYear() + "\n");
        Class<?> bootstrap = null;
        try {
            bootstrap = Class.forName("org.apache.catalina.startup.Bootstrap");
        }
        catch (ClassNotFoundException cnfe) {
            throw new Exception("\n Apache Tomcat bootstrap.jar must be in classpath.");
        }
        String whome = System.getProperty("openl.webstudio.home");
        if (whome == null) {
            whome = StartTomcat.getProperty(args, "openl.webstudio.home");
        }
        if (whome == null) {
            whome = "..";
        }
        if (!(webstudioHome = new File(whome)).exists()) {
            throw new Exception(MessageFormat.format("\nYou did not set up correctly openl.webstudio.home variable. It was \"{0}\".\n Please refer to OpenL Tablets document 'Web Programming and OpenL Tablets'. Chapter - Web Develoment Setup", whome));
        }
        System.setProperty("openl.webstudio.home", webstudioHome.getCanonicalPath());
        System.out.println("OpenL Tablets WebStudio home: " + System.getProperty("openl.webstudio.home"));
        String chome = System.getProperty("catalina.home");
        if (chome == null) {
            chome = StartTomcat.getProperty(args, "catalina.home");
        }
        if (chome == null) {
            chome = StartTomcat.findChome();
        }
        if (!(catalinaHome = new File(chome)).exists()) {
            throw new Exception(MessageFormat.format("\nYou did not set up correctly catalina.home variable. It was \"{0}\".\n Please refer to OpenL Tablets document 'Web Programming and OpenL Tablets'. Chapter - Web Develoment Setup", chome));
        }
        System.setProperty("catalina.home", catalinaHome.getCanonicalPath());
        System.out.println("Using tomcat home: " + System.getProperty("catalina.home"));
        String cbase = System.getProperty("catalina.base");
        if (cbase == null) {
            cbase = StartTomcat.getProperty(args, "catalina.base");
        }
        if (cbase == null) {
            cbase = ".";
        }
        File catalinaBase = new File(cbase);
        System.setProperty("catalina.base", catalinaBase.getCanonicalPath());
        System.out.println("Using tomcat base: " + System.getProperty("catalina.base"));
        Method main = bootstrap.getMethod("main", String[].class);
        String browserURL = System.getProperty(BROWSER_URL_PROPERTY);
        if (browserURL == null) {
            browserURL = StartTomcat.getProperty(args, BROWSER_URL_PROPERTY);
        }
        if (browserURL == null) {
            System.out.println("Using default browser url: http://localhost:8080/webstudio/");
            browserURL = DEFAULT_BROWSER_URL;
        }
        new Thread(new BrowserStarter(browserURL)).start();
        main.invoke(null, new Object[]{new String[]{"start"}});
    }

    private static class BrowserStarter
    implements Runnable {
        private String browserURL;

        public BrowserStarter(String browserURL) {
            this.browserURL = browserURL;
        }

        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            try {
                Method isDesktopSupportedMethod;
                Class<?> desktop = null;
                try {
                    desktop = Class.forName("java.awt.Desktop");
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                boolean isDesktopSupported = false;
                if (desktop != null && (isDesktopSupported = ((Boolean)(isDesktopSupportedMethod = desktop.getMethod("isDesktopSupported", new Class[0])).invoke(null, new Object[0])).booleanValue())) {
                    Method getDesktop = desktop.getMethod("getDesktop", new Class[0]);
                    Object desktopObject = getDesktop.invoke(null, new Object[0]);
                    Method browse = desktop.getMethod("browse", URI.class);
                    browse.invoke(desktopObject, new URI(this.browserURL));
                }
                if (desktop == null || !isDesktopSupported) {
                    BrowserLauncher browserLauncher = new BrowserLauncher();
                    browserLauncher.openURLinBrowser(this.browserURL);
                }
            }
            catch (Exception ex) {
                Log.error((String)"Could not start a browser. Error: {0}", (Throwable)ex, (Object[])new Object[]{ex.getMessage()});
            }
        }
    }
}

